"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = require("react");

var _core = require("@deck.gl/core");

var _useIsomorphicLayoutEffect = _interopRequireDefault(require("./utils/use-isomorphic-layout-effect"));

var _extractJsxLayers = _interopRequireDefault(require("./utils/extract-jsx-layers"));

var _positionChildrenUnderViews = _interopRequireDefault(require("./utils/position-children-under-views"));

var _extractStyles = _interopRequireDefault(require("./utils/extract-styles"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function getRefHandles(thisRef) {
  return {
    get deck() {
      return thisRef.deck;
    },

    pickObject: function pickObject(opts) {
      return thisRef.deck.pickObject(opts);
    },
    pickMultipleObjects: function pickMultipleObjects(opts) {
      return thisRef.deck.pickMultipleObjects(opts);
    },
    pickObjects: function pickObjects(opts) {
      return thisRef.deck.pickObjects(opts);
    }
  };
}

function redrawDeck(thisRef) {
  if (thisRef.redrawReason) {
    thisRef.deck._drawLayers(thisRef.redrawReason);

    thisRef.redrawReason = null;
  }
}

function createDeckInstance(thisRef, DeckClass, props) {
  var deck = new DeckClass(_objectSpread(_objectSpread({}, props), {}, {
    _customRender: function _customRender(redrawReason) {
      thisRef.redrawReason = redrawReason;
      var viewports = deck.getViewports();

      if (thisRef.lastRenderedViewports !== viewports) {
        thisRef.forceUpdate();
      } else {
        redrawDeck(thisRef);
      }
    }
  }));
  return deck;
}

var DeckGL = (0, _react.forwardRef)(function (props, ref) {
  var _useState = (0, _react.useState)(0),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      version = _useState2[0],
      setVersion = _useState2[1];

  var _thisRef = (0, _react.useRef)({
    control: null,
    version: version,
    forceUpdate: function forceUpdate() {
      return setVersion(function (v) {
        return v + 1;
      });
    }
  });

  var thisRef = _thisRef.current;
  var containerRef = (0, _react.useRef)(null);
  var canvasRef = (0, _react.useRef)(null);
  var jsxProps = (0, _react.useMemo)(function () {
    return (0, _extractJsxLayers.default)(props);
  }, [props.layers, props.views, props.children]);
  var inRender = true;

  var handleViewStateChange = function handleViewStateChange(params) {
    var _props$onViewStateCha;

    if (inRender && props.viewState) {
      thisRef.viewStateUpdateRequested = params;
      return null;
    }

    thisRef.viewStateUpdateRequested = null;
    return (_props$onViewStateCha = props.onViewStateChange) === null || _props$onViewStateCha === void 0 ? void 0 : _props$onViewStateCha.call(props, params);
  };

  var handleInteractionStateChange = function handleInteractionStateChange(params) {
    if (inRender) {
      thisRef.interactionStateUpdateRequested = params;
    } else {
      var _props$onInteractionS;

      thisRef.interactionStateUpdateRequested = null;
      (_props$onInteractionS = props.onInteractionStateChange) === null || _props$onInteractionS === void 0 ? void 0 : _props$onInteractionS.call(props, params);
    }
  };

  var deckProps = (0, _react.useMemo)(function () {
    var forwardProps = _objectSpread(_objectSpread({}, props), {}, {
      style: null,
      width: '100%',
      height: '100%',
      parent: containerRef.current,
      canvas: canvasRef.current,
      layers: jsxProps.layers,
      views: jsxProps.views,
      onViewStateChange: handleViewStateChange,
      onInteractionStateChange: handleInteractionStateChange
    });

    delete forwardProps._customRender;

    if (thisRef.deck) {
      thisRef.deck.setProps(forwardProps);
    }

    return forwardProps;
  }, [props]);
  (0, _react.useEffect)(function () {
    var DeckClass = props.Deck || _core.Deck;
    thisRef.deck = createDeckInstance(thisRef, DeckClass, _objectSpread(_objectSpread({}, deckProps), {}, {
      parent: containerRef.current,
      canvas: canvasRef.current
    }));
    return function () {
      var _thisRef$deck;

      return (_thisRef$deck = thisRef.deck) === null || _thisRef$deck === void 0 ? void 0 : _thisRef$deck.finalize();
    };
  }, []);
  (0, _useIsomorphicLayoutEffect.default)(function () {
    redrawDeck(thisRef);
    var viewStateUpdateRequested = thisRef.viewStateUpdateRequested,
        interactionStateUpdateRequested = thisRef.interactionStateUpdateRequested;

    if (viewStateUpdateRequested) {
      handleViewStateChange(viewStateUpdateRequested);
    }

    if (interactionStateUpdateRequested) {
      handleInteractionStateChange(interactionStateUpdateRequested);
    }
  });
  (0, _react.useImperativeHandle)(ref, function () {
    return getRefHandles(thisRef);
  }, []);
  var currentViewports = thisRef.deck && thisRef.deck.isInitialized ? thisRef.deck.getViewports() : undefined;
  var ContextProvider = props.ContextProvider,
      width = props.width,
      height = props.height,
      id = props.id,
      style = props.style;

  var _useMemo = (0, _react.useMemo)(function () {
    return (0, _extractStyles.default)({
      width: width,
      height: height,
      style: style
    });
  }, [width, height, style]),
      containerStyle = _useMemo.containerStyle,
      canvasStyle = _useMemo.canvasStyle;

  if (!thisRef.viewStateUpdateRequested && thisRef.lastRenderedViewports === currentViewports || thisRef.version !== version) {
    thisRef.lastRenderedViewports = currentViewports;
    thisRef.version = version;
    var childrenUnderViews = (0, _positionChildrenUnderViews.default)({
      children: jsxProps.children,
      deck: thisRef.deck,
      ContextProvider: ContextProvider
    });
    var canvas = (0, _react.createElement)('canvas', {
      key: 'canvas',
      id: id || 'deckgl-overlay',
      ref: canvasRef,
      style: canvasStyle
    });
    thisRef.control = (0, _react.createElement)('div', {
      id: "".concat(id || 'deckgl', "-wrapper"),
      ref: containerRef,
      style: containerStyle
    }, [canvas, childrenUnderViews]);
  }

  inRender = false;
  return thisRef.control;
});
DeckGL.defaultProps = _core.Deck.defaultProps;
var _default = DeckGL;
exports.default = _default;
//# sourceMappingURL=deckgl.js.map