"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = evaluateChildren;
exports.isComponent = isComponent;

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _react = require("react");

var MAP_STYLE = {
  position: 'absolute',
  zIndex: -1
};

function evaluateChildren(children, childProps) {
  if (typeof children === 'function') {
    return children(childProps);
  }

  if (Array.isArray(children)) {
    return children.map(function (child) {
      return evaluateChildren(child, childProps);
    });
  }

  if (isComponent(children)) {
    if (isReactMap(children)) {
      childProps.style = MAP_STYLE;
      return (0, _react.cloneElement)(children, childProps);
    }

    if (needsDeckGLViewProps(children)) {
      return (0, _react.cloneElement)(children, childProps);
    }
  }

  return children;
}

function isComponent(child) {
  return child && (0, _typeof2.default)(child) === 'object' && 'type' in child || false;
}

function isReactMap(child) {
  var _child$props;

  return (_child$props = child.props) === null || _child$props === void 0 ? void 0 : _child$props.mapStyle;
}

function needsDeckGLViewProps(child) {
  var componentClass = child.type;
  return componentClass && componentClass.deckGLViewProps;
}
//# sourceMappingURL=evaluate-children.js.map