"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = extractJSXLayers;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var React = _interopRequireWildcard(require("react"));

var _inheritsFrom = require("./inherits-from");

var _core = require("@deck.gl/core");

var _evaluateChildren = require("./evaluate-children");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function wrapInView(node) {
  if (typeof node === 'function') {
    return (0, React.createElement)(_core.View, {}, node);
  }

  if (Array.isArray(node)) {
    return node.map(wrapInView);
  }

  if ((0, _evaluateChildren.isComponent)(node)) {
    if (node.type === React.Fragment) {
      return wrapInView(node.props.children);
    }

    if ((0, _inheritsFrom.inheritsFrom)(node.type, _core.View)) {
      return node;
    }
  }

  return node;
}

function extractJSXLayers(_ref) {
  var children = _ref.children,
      _ref$layers = _ref.layers,
      layers = _ref$layers === void 0 ? [] : _ref$layers,
      _ref$views = _ref.views,
      views = _ref$views === void 0 ? null : _ref$views;
  var reactChildren = [];
  var jsxLayers = [];
  var jsxViews = {};
  React.Children.forEach(wrapInView(children), function (reactElement) {
    if ((0, _evaluateChildren.isComponent)(reactElement)) {
      var ElementType = reactElement.type;

      if ((0, _inheritsFrom.inheritsFrom)(ElementType, _core.Layer)) {
        var layer = createLayer(ElementType, reactElement.props);
        jsxLayers.push(layer);
      } else {
        reactChildren.push(reactElement);
      }

      if ((0, _inheritsFrom.inheritsFrom)(ElementType, _core.View) && ElementType !== _core.View && reactElement.props.id) {
        var view = new ElementType(reactElement.props);
        jsxViews[view.id] = view;
      }
    } else if (reactElement) {
      reactChildren.push(reactElement);
    }
  });

  if (Object.keys(jsxViews).length > 0) {
    if (Array.isArray(views)) {
      views.forEach(function (view) {
        jsxViews[view.id] = view;
      });
    } else if (views) {
      jsxViews[views.id] = views;
    }

    views = Object.values(jsxViews);
  }

  layers = jsxLayers.length > 0 ? [].concat(jsxLayers, (0, _toConsumableArray2.default)(layers)) : layers;
  return {
    layers: layers,
    children: reactChildren,
    views: views
  };
}

function createLayer(LayerType, reactProps) {
  var props = {};
  var defaultProps = LayerType.defaultProps || {};

  for (var key in reactProps) {
    if (defaultProps[key] !== reactProps[key]) {
      props[key] = reactProps[key];
    }
  }

  return new LayerType(props);
}
//# sourceMappingURL=extract-jsx-layers.js.map