"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = positionChildrenUnderViews;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _react = require("react");

var _core = require("@deck.gl/core");

var _inheritsFrom = require("./inherits-from");

var _evaluateChildren = _interopRequireWildcard(require("./evaluate-children"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function positionChildrenUnderViews(_ref) {
  var children = _ref.children,
      deck = _ref.deck,
      ContextProvider = _ref.ContextProvider;

  var _ref2 = deck || {},
      viewManager = _ref2.viewManager;

  if (!viewManager || !viewManager.views.length) {
    return [];
  }

  var views = {};
  var defaultViewId = viewManager.views[0].id;

  var _iterator = _createForOfIteratorHelper(children),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var child = _step.value;
      var viewId = defaultViewId;
      var viewChildren = child;

      if ((0, _evaluateChildren.isComponent)(child) && (0, _inheritsFrom.inheritsFrom)(child.type, _core.View)) {
        viewId = child.props.id || defaultViewId;
        viewChildren = child.props.children;
      }

      var viewport = viewManager.getViewport(viewId);
      var viewState = viewManager.getViewState(viewId);

      if (viewport) {
        viewState.padding = viewport.padding;
        var x = viewport.x,
            y = viewport.y,
            width = viewport.width,
            height = viewport.height;
        viewChildren = (0, _evaluateChildren.default)(viewChildren, {
          x: x,
          y: y,
          width: width,
          height: height,
          viewport: viewport,
          viewState: viewState
        });

        if (!views[viewId]) {
          views[viewId] = {
            viewport: viewport,
            children: []
          };
        }

        views[viewId].children.push(viewChildren);
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  return Object.keys(views).map(function (viewId) {
    var _views$viewId = views[viewId],
        viewport = _views$viewId.viewport,
        viewChildren = _views$viewId.children;
    var x = viewport.x,
        y = viewport.y,
        width = viewport.width,
        height = viewport.height;
    var style = {
      position: 'absolute',
      left: x,
      top: y,
      width: width,
      height: height
    };
    var key = "view-".concat(viewId);

    var viewElement = _react.createElement.apply(void 0, ['div', {
      key: key,
      id: key,
      style: style
    }].concat((0, _toConsumableArray2.default)(viewChildren)));

    if (ContextProvider) {
      var contextValue = {
        viewport: viewport,
        container: deck.canvas.offsetParent,
        eventManager: deck.eventManager,
        onViewStateChange: function onViewStateChange(params) {
          params.viewId = viewId;

          deck._onViewStateChange(params);
        }
      };
      return (0, _react.createElement)(ContextProvider, {
        key: key,
        value: contextValue
      }, viewElement);
    }

    return viewElement;
  });
}
//# sourceMappingURL=position-children-under-views.js.map