import { cloneElement } from 'react';
const MAP_STYLE = {
  position: 'absolute',
  zIndex: -1
};
export default function evaluateChildren(children, childProps) {
  if (typeof children === 'function') {
    return children(childProps);
  }

  if (Array.isArray(children)) {
    return children.map(child => evaluateChildren(child, childProps));
  }

  if (isComponent(children)) {
    if (isReactMap(children)) {
      childProps.style = MAP_STYLE;
      return cloneElement(children, childProps);
    }

    if (needsDeckGLViewProps(children)) {
      return cloneElement(children, childProps);
    }
  }

  return children;
}
export function isComponent(child) {
  return child && typeof child === 'object' && 'type' in child || false;
}

function isReactMap(child) {
  var _child$props;

  return (_child$props = child.props) === null || _child$props === void 0 ? void 0 : _child$props.mapStyle;
}

function needsDeckGLViewProps(child) {
  const componentClass = child.type;
  return componentClass && componentClass.deckGLViewProps;
}
//# sourceMappingURL=evaluate-children.js.map