const CANVAS_ONLY_STYLES = {
  mixBlendMode: null
};
export default function extractStyles({
  width,
  height,
  style
}) {
  const containerStyle = {
    position: 'absolute',
    zIndex: 0,
    left: 0,
    top: 0,
    width,
    height
  };
  const canvasStyle = {
    left: 0,
    top: 0
  };

  if (style) {
    for (const key in style) {
      if (key in CANVAS_ONLY_STYLES) {
        canvasStyle[key] = style[key];
      } else {
        containerStyle[key] = style[key];
      }
    }
  }

  return {
    containerStyle,
    canvasStyle
  };
}
//# sourceMappingURL=extract-styles.js.map