import { CameraFilesServiceConfig, FilesServiceConfig, MicrophoneFilesServiceConfig } from './types/fileServiceConfigs';
import { MessageStyles, MessageContent, OnNewMessage, ErrorMessages } from './types/messages';
import { ValidateMessageBeforeSending } from './types/validateMessageBeforeSending';
import { RequestInterceptor, ResponseInterceptor } from './types/interceptors';
import { InternalHTML } from './utils/webComponent/internalHTML';
import { DirectConnection } from './types/directConnection';
import { TextToSpeechConfig } from './types/textToSpeech';
import { SubmitButtonStyles } from './types/submitButton';
import { SpeechToTextConfig } from './types/microphone';
import { RequestBodyLimits } from './types/chatLimits';
import { DropupStyles } from './types/dropupStyles';
import { ServiceIO } from './services/serviceIO';
import { TextInput } from './types/textInput';
import { CustomStyle } from './types/styles';
import { Request } from './types/request';
import { Avatars } from './types/avatars';
import { Stream } from './types/stream';
import { Names } from './types/names';
export declare class DeepChat extends InternalHTML {
    directConnection?: DirectConnection;
    request?: Request;
    stream?: Stream;
    requestBodyLimits?: RequestBodyLimits;
    requestInterceptor?: RequestInterceptor;
    responseInterceptor?: ResponseInterceptor;
    validateMessageBeforeSending?: ValidateMessageBeforeSending;
    containerStyle?: CustomStyle;
    attachmentContainerStyle?: CustomStyle;
    dropupStyles?: DropupStyles;
    inputAreaStyle?: CustomStyle;
    textInput?: TextInput;
    submitButtonStyles?: SubmitButtonStyles;
    auxiliaryStyle?: string;
    initialMessages?: MessageContent[];
    introMessage?: string;
    avatars?: Avatars;
    names?: Names;
    displayLoadingBubble?: boolean;
    errorMessages?: ErrorMessages;
    messageStyles?: MessageStyles;
    textToSpeech?: boolean | TextToSpeechConfig;
    speechToText?: boolean | SpeechToTextConfig;
    images?: boolean | FilesServiceConfig;
    gifs?: boolean | FilesServiceConfig;
    camera?: boolean | CameraFilesServiceConfig;
    audio?: boolean | FilesServiceConfig;
    microphone?: boolean | MicrophoneFilesServiceConfig;
    mixedFiles?: boolean | FilesServiceConfig;
    dragAndDrop?: boolean | CustomStyle;
    introPanelStyle?: CustomStyle;
    getMessages: () => MessageContent[];
    submitUserMessage: (text: string) => void;
    focusInput: () => void;
    refreshMessages: () => void;
    clearMessages: (isReset?: boolean) => void;
    onNewMessage: OnNewMessage;
    onClearMessages: () => void;
    onComponentRender: () => void;
    _hasBeenRendered: boolean;
    _auxiliaryStyleApplied: boolean;
    _activeService?: ServiceIO;
    _childElement?: HTMLElement;
    constructor();
    private readonly _elementRef;
    private changeToChatView;
    onRender(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'deep-chat': DeepChat;
    }
}
//# sourceMappingURL=deepChat.d.ts.map