import { CameraFilesServiceConfig, MicrophoneFilesServiceConfig } from '../../types/fileServiceConfigs';
import { ValidateMessageBeforeSending } from '../../types/validateMessageBeforeSending';
import { Messages } from '../../views/chat/messages/messages';
import { MessageContent } from '../../types/messages';
import { Request } from '../../types/request';
import { Demo } from '../../utils/demo/demo';
import { Result } from '../../types/result';
import { DeepChat } from '../../deepChat';
import { KeyVerificationHandlers, CompletionsHandlers, ServiceFileTypes, RequestContents, StreamHandlers, ServiceIO } from '../serviceIO';
export declare class BaseServiceIO implements ServiceIO {
    readonly rawBody: any;
    deepChat: DeepChat;
    validateConfigKey: boolean;
    canSendMessage: ValidateMessageBeforeSending;
    requestSettings: Request;
    fileTypes: ServiceFileTypes;
    camera?: CameraFilesServiceConfig;
    recordAudio?: MicrophoneFilesServiceConfig;
    totalMessagesMaxCharLength?: number;
    maxMessages?: number;
    private readonly _directServiceRequiresFiles;
    demo?: Demo;
    websocket?: WebSocket;
    completionsHandlers: CompletionsHandlers;
    streamHandlers: StreamHandlers;
    constructor(deepChat: DeepChat, existingFileTypes?: ServiceFileTypes, demo?: Demo);
    private static canSendMessage;
    verifyKey(_key: string, _keyVerificationHandlers: KeyVerificationHandlers): void;
    private static createCustomFormDataBody;
    private getServiceIOByType;
    callServiceAPI(messages: Messages, pMessages: MessageContent[], _?: File[]): Promise<void>;
    callApiWithFiles(body: any, messages: Messages, pMessages: MessageContent[], files: File[]): Promise<void>;
    callAPI(requestContents: RequestContents, messages: Messages): Promise<void>;
    extractResultData(result: any | Result): Promise<Result | {
        pollingInAnotherRequest: true;
    }>;
}
//# sourceMappingURL=baseServiceIO.d.ts.map