import { GenericObject } from './object';
export interface CohereSummarizationConfig {
    model?: 'summarize-xlarge' | 'summarize-medium';
    length?: 'auto' | 'short' | 'medium' | 'long';
    format?: 'auto' | 'paragraph' | 'bullets';
    extractiveness?: 'auto' | 'low' | 'medium' | 'high';
    temperature?: number;
    additional_command?: string;
}
export interface CohereGenerateConfig {
    model?: 'command' | 'base' | 'base-light';
    max_tokens?: number;
    temperature?: number;
    k?: number;
    p?: number;
    frequency_penalty?: number;
    presence_penalty?: number;
    end_sequences?: string[];
    stop_sequences?: string[];
    logit_bias?: GenericObject<string | number>;
    truncate?: 'NONE' | 'START' | 'END';
}
export interface CohereChatConfig {
    model?: string;
    user_name?: string;
    temperature?: number;
    max_tokens?: number;
}
export interface Cohere {
    chat?: true | CohereChatConfig;
    textGeneration?: true | CohereGenerateConfig;
    summarization?: true | CohereSummarizationConfig;
}
//# sourceMappingURL=cohere.d.ts.map