import { AzureOptions, Commands, TextColor, Translations, WebSpeechOptions } from 'speech-to-element/dist/types/options';
import { ButtonStyles, ButtonPosition } from './button';
export interface MicrophoneStyles {
    default?: ButtonStyles;
    active?: ButtonStyles;
    unsupported?: ButtonStyles;
    position?: ButtonPosition;
}
export type AudioFormat = 'mp3' | '4a' | 'webm' | 'mp4' | 'mpga' | 'wav' | 'mpeg' | 'm4a';
export interface AudioRecordingFiles {
    format?: AudioFormat;
    acceptedFormats?: string;
    maxNumberOfFiles?: number;
    maxDurationSeconds?: number;
}
export type SpeechToTextConfig = {
    webSpeech?: true | WebSpeechOptions;
    azure?: AzureOptions;
    displayInterimResults?: boolean;
    textColor?: TextColor;
    translations?: Translations;
    commands?: Commands & {
        submit?: string;
    };
    button?: {
        commandMode?: ButtonStyles;
    } & MicrophoneStyles;
};
//# sourceMappingURL=microphone.d.ts.map