export interface OpenAIMessage {
    role: 'user' | 'system' | 'ai';
    content: string;
}
export type OpenAIAudioType = {
    type?: 'transcription' | 'translation';
};
export type OpenAIAudio = {
    model?: 'whisper-1';
    temperature?: number;
    language?: string;
};
export interface OpenAIImages {
    n?: number;
    size?: '256x256' | '512x512' | '1024x1024';
    response_format?: 'url' | 'b64_json';
    user?: string;
}
export type OpenAIChat = {
    systemPrompt?: string;
};
export interface OpenAIConverse {
    model?: string;
    max_tokens?: number;
    temperature?: number;
    top_p?: number;
}
export interface OpenAI {
    chat?: true | (OpenAIConverse & OpenAIChat);
    completions?: true | OpenAIConverse;
    images?: true | OpenAIImages;
    audio?: true | (OpenAIAudio & OpenAIAudioType);
}
//# sourceMappingURL=openAI.d.ts.map