import { FileAttachments } from '../../../../../types/fileAttachments';
import { MessageFileType } from '../../../../../types/messageFile';
export interface AttachmentObject {
    file: File;
    fileType: MessageFileType;
    attachmentContainerElement: HTMLElement;
    removeButton?: HTMLElement;
}
export declare class FileAttachmentsType {
    private readonly _attachments;
    private readonly _fileCountLimit;
    private readonly _toggleContainerDisplay;
    private readonly _fileAttachmentsContainerRef;
    private readonly _acceptedFormat;
    constructor(fileAttachments: FileAttachments, toggleContainer: (display: boolean) => void, container: HTMLElement);
    attemptAddFile(file: File, fileReaderResult: string): boolean;
    private static isFileTypeValid;
    private addAttachmentBasedOnType;
    private static createImageAttachment;
    private static createAnyFileAttachment;
    addFileAttachment(file: File, fileType: MessageFileType, attachmentElement: HTMLElement, removable: boolean): AttachmentObject;
    private static createContainer;
    createRemoveAttachmentButton(attachmentObject: AttachmentObject): HTMLDivElement;
    removeAttachment(attachmentObject: AttachmentObject): void;
    getFiles(): {
        file: File;
        type: MessageFileType;
    }[];
    removeAllAttachments(): void;
}
//# sourceMappingURL=fileAttachmentsType.d.ts.map