import { MessageFile, MessageFileType } from '../../../types/messageFile';
import { ServiceIO } from '../../../services/serviceIO';
import { Result as MessageData } from '../../../types/result';
import { DemoResponse } from '../../../types/demo';
import { DeepChat } from '../../../deepChat';
import { ErrorMessageOverrides, MessageElementsStyles, MessageRoleStyles, MessageContent, MessageStyles } from '../../../types/messages';
export interface MessageElements {
    outerContainer: HTMLElement;
    innerContainer: HTMLElement;
    bubbleElement: HTMLElement;
}
export declare class Messages {
    elementRef: HTMLElement;
    readonly messageStyles?: MessageStyles;
    private _messageElementRefs;
    private readonly _avatars?;
    private readonly _names?;
    private readonly _errorMessageOverrides?;
    private readonly _onNewMessage?;
    private readonly _onClearMessages?;
    private readonly _displayLoadingMessage?;
    private readonly _permittedErrorPrefixes?;
    private readonly displayServiceErrorMessages?;
    private _remarkable;
    private _textToSpeech?;
    private _introPanel?;
    private _introMessage?;
    private _streamedText;
    messages: MessageContent[];
    customDemoResponse?: DemoResponse;
    constructor(deepChat: DeepChat, serviceIO: ServiceIO, panel?: HTMLElement);
    private static getDisplayLoadingMessage;
    private prepareDemo;
    private static createContainerElement;
    private addIntroductoryMessage;
    private populateInitialMessages;
    applyCustomStyles(elements: MessageElements, isAI: boolean, media: boolean, otherStyles?: MessageRoleStyles | MessageElementsStyles): void;
    private addInnerContainerElements;
    static createMessageContent(isAI: boolean, text?: string, file?: MessageFile): MessageContent;
    private static createBaseElements;
    private createMessageElements;
    createNewMessageElement(text: string, isAI: boolean): MessageElements;
    private createAndAppendNewMessageElement;
    private static editEmptyMessageElement;
    private addNewTextMessage;
    addNewMessage(data: MessageData, isAI: boolean, update: boolean, isInitial?: boolean): void;
    sendClientUpdate(message: MessageContent, isInitial?: boolean): void;
    private removeMessageOnError;
    addNewErrorMessage(type: keyof Omit<ErrorMessageOverrides, 'default'>, message?: string): void;
    private static checkPermittedErrorPrefixes;
    private getPermittedMessage;
    isLastMessageError(): boolean;
    removeError(): void;
    addLoadingMessage(): void;
    addNewStreamedMessage(): HTMLElement;
    updateStreamedMessage(text: string, bubbleElement: HTMLElement): void;
    finaliseStreamedMessage(): void;
    private populateIntroPanel;
    addMultipleFiles(filesData: {
        file: File;
        type: MessageFileType;
    }[]): Promise<unknown[]>;
    private clearMessages;
    private refreshTextMessages;
}
//# sourceMappingURL=messages.d.ts.map