import { Array1D, Array2D, Array3D, Array4D, NDArray, Scalar } from './ndarray';
export declare type ScopeResult = NDArray[] | NDArray | void;
export interface LSTMCell {
    (data: Array2D, c: Array2D, h: Array2D): [Array2D, Array2D];
}
export declare abstract class NDArrayMath {
    private safeMode;
    private ndarrayScopes;
    private activeScope;
    private ndarraysToKeep;
    private activeScopeNDArraysToKeep;
    private debugMode;
    constructor(safeMode: boolean);
    scope<T extends ScopeResult>(scopeFn: (keep: <T1 extends NDArray>(ndarray: T1) => T1, track: <T2 extends NDArray>(ndarray: T2) => T2) => T): T;
    enableDebugMode(): void;
    startScope(): void;
    endScope(result: ScopeResult): void;
    private isNDArrayDataInList(ndarray, ndarrayList);
    keep<T extends NDArray>(result: T): T;
    private checkForNaN(arr);
    track<T extends NDArray>(result: T): T;
    matMul(a: Array2D, b: Array2D, aOrientation?: MatrixOrientation, bOrientation?: MatrixOrientation): Array2D;
    protected abstract matMulInternal(a: Array2D, b: Array2D, aOrientation: MatrixOrientation, bOrientation: MatrixOrientation): Array2D;
    vectorTimesMatrix(v: Array1D, matrix: Array2D): Array1D;
    matrixTimesVector(matrix: Array2D, v: Array1D): Array1D;
    dotProduct(v1: Array1D, v2: Array1D): Scalar;
    outerProduct(v1: Array1D, v2: Array1D): Array2D;
    clone<T extends NDArray>(ndarray: T): T;
    protected abstract cloneInternal<T extends NDArray>(ndarray: T): T;
    reshape<T1 extends NDArray, T2 extends NDArray>(ndarray: T1, newShape: number[]): T2;
    slice2D(input: Array2D, begin: [number, number], size: [number, number]): Array2D;
    protected abstract slice2DInternal(input: Array2D, begin: [number, number], size: [number, number]): Array2D;
    copy2D(source: Array2D, sourceBegin: [number, number], sourceSize: [number, number], dest: Array2D, destBegin: [number, number], destSize: [number, number]): void;
    protected abstract copy2DInternal(source: Array2D, sourceBegin: [number, number], sourceSize: [number, number], dest: Array2D, destBegin: [number, number], destSize: [number, number]): void;
    concat3D(ndarray1: Array3D, ndarray2: Array3D, axis: number): Array3D;
    protected abstract concat3DInternal(ndarray1: Array3D, ndarray2: Array3D, axis: number): Array3D;
    logSumExp(ndarray: NDArray): Scalar;
    protected abstract logSumExpInternal(ndarray: NDArray): Scalar;
    sum(ndarray: NDArray): Scalar;
    protected abstract sumInternal(ndarray: NDArray): Scalar;
    argMin(ndarray: NDArray): Scalar;
    protected abstract argMinInternal(ndarray: NDArray): Scalar;
    argMax(ndarray: NDArray): Scalar;
    protected abstract argMaxInternal(ndarray: NDArray): Scalar;
    argMaxEquals(x1: NDArray, x2: NDArray): Scalar;
    protected abstract argMaxEqualsInternal(x1: NDArray, x2: NDArray): Scalar;
    topK(ndarray: NDArray, k: number): {
        values: Array1D;
        indices: Array1D;
    };
    protected abstract topKInternal(ndarray: NDArray, k: number): {
        values: Array1D;
        indices: Array1D;
    };
    min(ndarray: NDArray): Scalar;
    protected abstract minInternal(ndarray: NDArray): Scalar;
    max(ndarray: NDArray): Scalar;
    protected abstract maxInternal(ndarray: NDArray): Scalar;
    softmax(x: Array1D): Array1D;
    switchDim<T extends NDArray>(a: T, newDim: number[]): T;
    protected abstract switchDimInternal<T extends NDArray>(a: T, newDim: number[]): T;
    scalarPlusArray<T extends NDArray>(c: Scalar, a: T): T;
    scalarMinusArray<T extends NDArray>(c: Scalar, a: T): T;
    arrayMinusScalar<T extends NDArray>(a: T, c: Scalar): T;
    neg<T extends NDArray>(a: T): T;
    protected abstract negInternal<T extends NDArray>(a: T): T;
    add(a: NDArray, b: NDArray): NDArray;
    protected abstract addInternal(a: NDArray, b: NDArray): NDArray;
    addStrict<T extends NDArray>(a: T, b: T): T;
    sub(a: NDArray, b: NDArray): NDArray;
    protected abstract subInternal(a: NDArray, b: NDArray): NDArray;
    subStrict<T extends NDArray>(a: T, b: T): T;
    multiply(a: NDArray, b: NDArray): NDArray;
    protected abstract multiplyInternal<T extends NDArray>(a: T, b: T): T;
    elementWiseMul<T extends NDArray>(a: T, b: T): T;
    multiplyStrict<T extends NDArray>(a: T, b: T): T;
    divide(a: NDArray, b: NDArray): NDArray;
    protected abstract divideInternal(a: NDArray, b: NDArray): NDArray;
    divideStrict<T extends NDArray>(a: T, b: T): T;
    scalarDividedByArray<T extends NDArray>(c: Scalar, a: T): T;
    arrayDividedByScalar<T extends NDArray>(a: T, c: Scalar): T;
    exp<T extends NDArray>(ndarray: T): T;
    protected abstract expInternal<T extends NDArray>(ndarray: T): T;
    log<T extends NDArray>(ndarray: T): T;
    protected abstract logInternal<T extends NDArray>(ndarray: T): T;
    relu<T extends NDArray>(ndarray: T): T;
    protected abstract reluInternal<T extends NDArray>(ndarray: T): T;
    sigmoid<T extends NDArray>(ndarray: T): T;
    protected abstract sigmoidInternal<T extends NDArray>(ndarray: T): T;
    tanh<T extends NDArray>(ndarray: T): T;
    protected abstract tanhInternal<T extends NDArray>(ndarray: T): T;
    sin<T extends NDArray>(ndarray: T): T;
    protected abstract sinInternal<T extends NDArray>(ndarray: T): T;
    step<T extends NDArray>(ndarray: T): T;
    protected abstract stepInternal<T extends NDArray>(ndarray: T): T;
    scaledArrayAdd<T extends NDArray>(c1: Scalar, a: T, c2: Scalar, b: T): T;
    protected abstract scaledArrayAddInternal<T extends NDArray>(c1: Scalar, a: T, c2: Scalar, b: T): T;
    scalarTimesArray<T extends NDArray>(c: Scalar, a: T): T;
    elementWiseMulBroadcast(a: Array2D, b: Array2D): Array2D;
    conv2d(x: Array3D, weights: Array4D, biases: Array1D | null, stride: number, zeroPad: number): Array3D;
    protected abstract conv2dInternal(x: Array3D, weights: Array4D, biases: Array1D | null, stride: number, zeroPad: number): Array3D;
    conv2dBackProp(x: Array3D, dy: Array3D, weights: Array4D, stride: number, pad: number): {
        dx: Array3D;
        dw: Array4D;
        db: Array1D;
    };
    protected abstract conv2dBackPropInternal(x: Array3D, dy: Array3D, weights: Array4D, stride: number, pad: number): {
        dx: Array3D;
        dw: Array4D;
        db: Array1D;
    };
    conv2dTranspose(x: Array3D, weights: Array4D, biases: Array1D | null, stride: number, pad: number): Array3D;
    protected abstract conv2dTransposeInternal(x: Array3D, weights: Array4D, biases: Array1D | null, stride: number, pad: number): Array3D;
    maxPool(x: Array3D, fSize: number, stride: number, pad: number): Array3D;
    protected abstract maxPoolInternal(x: Array3D, fSize: number, stride: number, pad: number): Array3D;
    maxPoolBackprop(dy: Array3D, x: Array3D, fSize: number, stride: number, pad: number): Array3D;
    protected abstract maxPoolBackpropInternal(dy: Array3D, x: Array3D, fSize: number, stride: number, pad: number): Array3D;
    minPool(x: Array3D, fSize: number, stride: number, pad: number): Array3D;
    protected abstract minPoolInternal(x: Array3D, fSize: number, stride: number, pad: number): Array3D;
    avgPool(x: Array3D, fSize: number, stride: number, pad: number): Array3D;
    protected abstract avgPoolInternal(x: Array3D, fSize: number, stride: number, pad: number): Array3D;
    resizeBilinear3D(x: Array3D, newShape2D: [number, number], alignCorners?: boolean): Array3D;
    protected abstract resizeBilinear3DInternal(x: Array3D, newShape2D: [number, number], alignCorners: boolean): Array3D;
    batchNormalization3D(x: Array3D, mean: Array3D | Array1D, variance: Array3D | Array1D, varianceEpsilon?: number, scale?: Array3D | Array1D, offset?: Array3D | Array1D): Array3D;
    protected abstract batchNormalization3DInternal(x: Array3D, mean: Array3D | Array1D, variance: Array3D | Array1D, varianceEpsilon: number, scale?: Array3D | Array1D, offset?: Array3D | Array1D): Array3D;
    multiRNNCell(lstmCells: LSTMCell[], data: Array2D, c: Array2D[], h: Array2D[]): [Array2D[], Array2D[]];
    basicLSTMCell(forgetBias: Scalar, lstmKernel: Array2D, lstmBias: Array1D, data: Array2D, c: Array2D, h: Array2D): [Array2D, Array2D];
}
export declare enum MatrixOrientation {
    REGULAR = 0,
    TRANSPOSED = 1,
}
