import { MatrixOrientation, NDArrayMath } from './math';
import { Array1D, Array2D, Array3D, Array4D, NDArray, Scalar } from './ndarray';
export declare class NDArrayMathCPU extends NDArrayMath {
    constructor(safeMode?: boolean);
    protected cloneInternal<T extends NDArray>(ndarray: T): T;
    protected slice2DInternal(input: Array2D, beginRowCol: [number, number], sizeRowCol: [number, number]): Array2D;
    protected copy2DInternal(source: Array2D, sourceBeginRowCol: [number, number], sourceSizeRowCol: [number, number], dest: Array2D, destBeginRowCol: [number, number], destSizeRowCol: [number, number]): void;
    protected concat3DInternal(x1: Array3D, x2: Array3D, axis: number): Array3D;
    protected scaledArrayAddInternal<T extends NDArray>(c1: Scalar, a: T, c2: Scalar, b: T): T;
    protected negInternal<T extends NDArray>(a: T): T;
    protected addInternal<T extends NDArray>(a: T, b: T): T;
    protected subInternal<T extends NDArray>(a: T, b: T): T;
    protected matMulInternal(a: Array2D, b: Array2D, aOrientation?: MatrixOrientation, bOrientation?: MatrixOrientation): Array2D;
    protected multiplyInternal<T extends NDArray>(a: T, b: T): T;
    protected divideInternal<T extends NDArray>(a: T, b: T): T;
    protected sumInternal(ndarray: NDArray): Scalar;
    protected argMinInternal(ndarray: NDArray): Scalar;
    protected argMaxInternal(ndarray: NDArray): Scalar;
    protected argMaxEqualsInternal(x1: NDArray, x2: NDArray): Scalar;
    protected topKInternal(ndarray: NDArray, k: number): {
        values: Array1D;
        indices: Array1D;
    };
    protected minInternal(ndarray: NDArray): Scalar;
    protected maxInternal(ndarray: NDArray): Scalar;
    protected expInternal<T extends NDArray>(ndarray: T): T;
    protected logInternal<T extends NDArray>(ndarray: T): T;
    protected logSumExpInternal(ndarray: NDArray): Scalar;
    protected reluInternal<T extends NDArray>(ndarray: T): T;
    protected sigmoidInternal<T extends NDArray>(ndarray: T): T;
    protected tanhInternal<T extends NDArray>(ndarray: T): T;
    protected sinInternal<T extends NDArray>(ndarray: T): T;
    protected stepInternal<T extends NDArray>(ndarray: T): T;
    protected conv2dInternal(x: Array3D, weights: Array4D, biases: Array1D | null, stride: number, pad: number): Array3D;
    protected conv2dBackPropInternal(x: Array3D, dy: Array3D, weights: Array4D, stride: number, pad: number): {
        dx: Array3D;
        dw: Array4D;
        db: Array1D;
    };
    protected conv2dTransposeInternal(x: Array3D, weights: Array4D, biases: Array1D | null, origStride: number, origPad: number): Array3D;
    protected conv2dTransposeShaderLike(x: Array3D, origWeights: Array4D, origStride: number, origPad: number): Array3D;
    conv2dDerWeights(x: Array3D, dY: Array3D, fSize: number, stride: number, zeroPad: number): Array4D;
    conv2dDerBias(dY: Array3D): Array1D;
    protected switchDimInternal<T extends NDArray>(t: T, newDim: number[]): T;
    private pool(x, fSize, stride, pad, poolType);
    protected maxPoolInternal(x: Array3D, fSize: number, stride: number, pad: number): Array3D;
    maxPoolPositions(x: Array3D, fSize: number, stride: number, pad: number): Array3D;
    protected maxPoolBackpropInternal(dy: Array3D, x: Array3D, fSize: number, origStride: number, origPad: number): Array3D;
    protected minPoolInternal(x: Array3D, fSize: number, stride: number, pad: number): Array3D;
    protected avgPoolInternal(x: Array3D, fSize: number, stride: number, pad: number): Array3D;
    protected resizeBilinear3DInternal(x: Array3D, newShape2D: [number, number], alignCorners: boolean): Array3D;
    protected batchNormalization3DInternal(x: Array3D, mean: Array3D | Array1D, variance: Array3D | Array1D, varianceEpsilon?: number, scale?: Array3D | Array1D, offset?: Array3D | Array1D): Array3D;
}
