"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var util = require("../../util");
var AddScaledMatProgram = (function () {
    function AddScaledMatProgram(aShape, bShape) {
        this.variableNames = ['A', 'B', 'c1', 'c2'];
        this.params = [];
        this.supportsBroadcasting = true;
        this.outputShape = util.assertAndGetBroadcastedShape(aShape, bShape);
        this.userCode = "\n      void main() {\n        float a = getAAtOutCoords();\n        float b = getBAtOutCoords();\n        float c1 = getC1();\n        float c2 = getC2();\n        setOutput(dot(vec2(c1, c2), vec2(a, b)));\n      }\n    ";
    }
    return AddScaledMatProgram;
}());
exports.AddScaledMatProgram = AddScaledMatProgram;
//# sourceMappingURL=addscaledmat_gpu.js.map