"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var concat3d_util = require("../concat3d_util");
var Concat3DProgram = (function () {
    function Concat3DProgram(x1Shape, x2Shape, axis) {
        this.variableNames = ['A', 'B'];
        this.params = [];
        this.outputShape = [];
        var yAxes = ['yR', 'yC', 'yD'];
        var concatAxis = yAxes[axis];
        this.params = [axis];
        this.outputShape =
            concat3d_util.computeConcat3DOutputShape(x1Shape, x2Shape, axis);
        this.userCode = "\n      void main() {\n        vec3 coords = getOutputCoords();\n        float yR = coords.x;\n        float yC = coords.y;\n        float yD = coords.z;\n\n        float value = 0.0;\n        if (" + concatAxis + " < " + x1Shape[axis] + ".0) {\n          value = getA(yR, yC, yD);\n        } else {\n          " + concatAxis + " -= " + x1Shape[axis] + ".0;\n          value = getB(yR, yC, yD);\n        }\n\n        setOutput(value);\n      }\n    ";
    }
    return Concat3DProgram;
}());
exports.Concat3DProgram = Concat3DProgram;
//# sourceMappingURL=concat3d_gpu.js.map