"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var conv_util = require("../conv_util");
var Conv2DDerWeightsProgram = (function () {
    function Conv2DDerWeightsProgram(xShape, fSize, outputDepth, stride, zeroPad) {
        this.variableNames = ['x', 'dy'];
        var yShape = conv_util.computeOutputShape3D(xShape, fSize, outputDepth, stride, zeroPad);
        var yNumRows = yShape[0];
        var yNumCols = yShape[1];
        var xNumRows = xShape[0];
        var xNumCols = xShape[1];
        this.outputShape =
            conv_util.computeWeightsShape4D(xShape[2], outputDepth, fSize);
        this.params = [stride, zeroPad];
        this.userCode = "\n      void main() {\n        vec4 coords = getOutputCoords();\n        float wR = coords.x;\n        float wC = coords.y;\n        float d1 = coords.z;\n        float d2 = coords.w;\n\n        // Convolve x(?, ?, d1) with dy(:, :, d2) to get dw(wR, wC, d1, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int iyR = 0; iyR < " + yNumRows + "; iyR++) {\n          float yR = float(iyR);\n          float xR = wR + yR * " + stride + ".0 - " + zeroPad + ".0;\n\n          if (xR < 0.0 || xR >= " + xNumRows + ".0) {\n            continue;\n          }\n\n          for (int iyC = 0; iyC < " + yNumCols + "; iyC++) {\n            float yC = float(iyC);\n            float xC = wC + yC * " + stride + ".0 - " + zeroPad + ".0;\n\n            if (xC < 0.0 || xC >= " + xNumCols + ".0) {\n              continue;\n            }\n\n            float dyValue = getDy(yR, yC, d2);\n            float xValue = getX(xR, xC, d1);\n            dotProd += (xValue * dyValue);\n          }\n        }\n        setOutput(dotProd);\n      }\n    ";
    }
    return Conv2DDerWeightsProgram;
}());
exports.Conv2DDerWeightsProgram = Conv2DDerWeightsProgram;
var Conv2DTransposeProgram = (function () {
    function Conv2DTransposeProgram(xShape, fSize, origInputDepth, origStride, origPad, hasBias) {
        this.variableNames = ['x', 'W', 'bias'];
        var xRows = xShape[0], xCols = xShape[1], origOutputDepth = xShape[2];
        var biasSnippet = hasBias ? 'dotProd += getBias(d2);' : '';
        var xRowsDilated = (xRows - 1) * origStride + 1;
        var xColsDilated = (xCols - 1) * origStride + 1;
        var pad = fSize - 1 - origPad;
        this.outputShape = conv_util.computeOutputShape3D([xRowsDilated, xColsDilated, origOutputDepth], fSize, origInputDepth, 1, pad);
        this.params = [pad, fSize, origStride, hasBias];
        this.userCode = "\n      void main() {\n        vec3 coords = getOutputCoords();\n        float yR = coords.x;\n        float yC = coords.y;\n        float d2 = coords.z;\n\n        vec2 xRCCorner = vec2(yR, yC) - vec2(" + pad + ".0, " + pad + ".0);\n        float xRCorner = xRCCorner.x;\n        float xCCorner = xRCCorner.y;\n\n        // Convolve x(?, ?, d1) with w(:, :, d2, d1) to get y(yR, yC, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int iwR = 0; iwR < " + fSize + "; iwR++) {\n          float wR = float(iwR);\n          float xR = (xRCorner + wR) / " + origStride + ".0;\n\n          if (xR < 0.0 || xR >= " + xRows + ".0 || fract(xR) > 0.0) {\n            continue;\n          }\n\n          float wRPerm = " + fSize + ".0 - 1.0 - wR;\n\n          for (int iwC = 0; iwC < " + fSize + "; iwC++) {\n            float wC = float(iwC);\n            float xC = (xCCorner + wC) / " + origStride + ".0;\n\n            if (xC < 0.0 || xC >= " + xCols + ".0 || fract(xC) > 0.0) {\n              continue;\n            }\n\n            float wCPerm = " + fSize + ".0 - 1.0 - wC;\n\n            for (int id1 = 0; id1 < " + origOutputDepth + "; id1++) {\n              float d1 = float(id1);\n              float xValue = getX(xR, xC, d1);\n              float wValue = getW(wRPerm, wCPerm, d2, d1);\n              dotProd += xValue * wValue;\n            }\n          }\n        }\n        " + biasSnippet + "\n        setOutput(dotProd);\n      }\n    ";
    }
    return Conv2DTransposeProgram;
}());
exports.Conv2DTransposeProgram = Conv2DTransposeProgram;
var Conv2DDerBiasProgram = (function () {
    function Conv2DDerBiasProgram(yShape) {
        this.variableNames = ['dy'];
        this.params = [];
        var yNumRows = yShape[0], yNumCols = yShape[1], outputDepth = yShape[2];
        this.outputShape = [outputDepth];
        this.userCode = "\n      void main() {\n        float d2 = getOutputCoords();\n\n        float derBias = 0.0;\n        for (int iyR = 0; iyR < " + yNumRows + "; iyR++) {\n          float yR = float(iyR);\n          for (int iyC = 0; iyC < " + yNumCols + "; iyC++) {\n            float yC = float(iyC);\n            derBias += getDy(yR, yC, d2);\n          }\n        }\n        setOutput(derBias);\n      }\n    ";
    }
    return Conv2DDerBiasProgram;
}());
exports.Conv2DDerBiasProgram = Conv2DDerBiasProgram;
//# sourceMappingURL=conv_backprop_gpu.js.map