"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var conv_util = require("../conv_util");
var Conv2DProgram = (function () {
    function Conv2DProgram(xShape, fieldSize, outputDepth, stride, pad, hasBias) {
        this.variableNames = ['x', 'W', 'bias'];
        this.outputShape = conv_util.computeOutputShape3D(xShape, fieldSize, outputDepth, stride, pad);
        var inputDepth = xShape[2];
        this.params = [fieldSize, stride, pad, hasBias];
        var biasSnippet = hasBias ? 'dotProd += getBias(d2);' : '';
        var xNumRows = xShape[0];
        var xNumCols = xShape[1];
        this.userCode = "\n      void main() {\n        vec3 coords = getOutputCoords();\n        float yR = coords.x;\n        float yC = coords.y;\n        float d2 = coords.z;\n\n        vec2 xRCCorner = vec2(yR, yC) * vec2(" + stride + ".0, " + stride + ".0) -\n            vec2(" + pad + ".0, " + pad + ".0);\n        float xRCorner = xRCCorner.x;\n        float xCCorner = xRCCorner.y;\n\n        // Convolve x(?, ?, d1) with w(:, :, d1, d2) to get y(yR, yC, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int iwR = 0; iwR < " + fieldSize + "; iwR++) {\n          float wR = float(iwR);\n          float xR = xRCorner + wR;\n\n          if (xR < 0.0 || xR >= " + xNumRows + ".0) {\n            continue;\n          }\n\n          for (int iwC = 0; iwC < " + fieldSize + "; iwC++) {\n            float wC = float(iwC);\n            float xC = xCCorner + wC;\n\n            if (xC < 0.0 || xC >= " + xNumCols + ".0) {\n              continue;\n            }\n\n            for (int id1 = 0; id1 < " + inputDepth + "; id1++) {\n              float d1 = float(id1);\n              float xValue = getX(xR, xC, d1);\n              float wValue = getW(wR, wC, d1, d2);\n              dotProd += xValue * wValue;\n            }\n          }\n        }\n        " + biasSnippet + "\n        setOutput(dotProd);\n      }\n    ";
    }
    return Conv2DProgram;
}());
exports.Conv2DProgram = Conv2DProgram;
//# sourceMappingURL=conv_gpu.js.map