"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Copy2DProgram = (function () {
    function Copy2DProgram(srcNumCols, destNumCols) {
        this.variableNames = ['source'];
        this.outputShape = null;
        this.params = [srcNumCols, destNumCols];
        this.userCode = "\n      uniform vec2 sourceStart;\n      uniform vec2 destStart;\n\n      void main() {\n        vec2 destCoords = getOutputCoords() - destStart;\n        float index = dot(destCoords, vec2(" + destNumCols + ".0, 1.0));\n        vec2 sourceCoords = sourceStart + vec2(\n          floor(index / " + srcNumCols + ".0),\n          mod(index, " + srcNumCols + ".0)\n        );\n        setOutput(getSource(sourceCoords.x, sourceCoords.y));\n      }\n    ";
    }
    Copy2DProgram.prototype.getCustomSetupFunc = function (sourceStart, destStart, destSize) {
        return function (gpgpu) {
            gpgpu.setOutputMatrixWriteRegion(destStart[0], destSize[0], destStart[1], destSize[1]);
            var sourceStartCRLoc = gpgpu.getUniformLocation('sourceStart');
            gpgpu.gl.uniform2f(sourceStartCRLoc, sourceStart[0], sourceStart[1]);
            var destStartCRLoc = gpgpu.getUniformLocation('destStart');
            gpgpu.gl.uniform2f(destStartCRLoc, destStart[0], destStart[1]);
        };
    };
    return Copy2DProgram;
}());
exports.Copy2DProgram = Copy2DProgram;
//# sourceMappingURL=copy_gpu.js.map