"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var conv_util = require("../conv_util");
var MaxPool2DBackpropProgram = (function () {
    function MaxPool2DBackpropProgram(dyShape, fSize, origStride, origPad) {
        this.variableNames = ['dy', 'maxPos'];
        var pad = fSize - 1 - origPad;
        var dyRows = dyShape[0];
        var dyCols = dyShape[1];
        this.params = [fSize, origStride, origPad];
        var dilatedDyRC = conv_util.computeDilatedRC([dyShape[0], dyShape[1]], origStride);
        this.outputShape = conv_util.computeOutputShape3D([dilatedDyRC[0], dilatedDyRC[1], dyShape[2]], fSize, dyShape[2], 1, pad);
        this.userCode = "\n      void main() {\n        vec3 coords = getOutputCoords();\n        float dxR = coords.x;\n        float dxC = coords.y;\n        float d = coords.z;\n\n        vec2 dyRCCorner = vec2(dxR, dxC) - vec2(" + pad + ".0, " + pad + ".0);\n        float dyRCorner = dyRCCorner.x;\n        float dyCCorner = dyRCCorner.y;\n\n        // Convolve dy(?, ?, d) with pos mask(:, :, d) to get dx(yR, dxC, d).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int iwR = 0; iwR < " + fSize + "; iwR++) {\n          float wR = float(iwR);\n          float dyR = (dyRCorner + wR) / " + origStride + ".0;\n\n          if (dyR < 0.0 || dyR >= " + dyRows + ".0 || fract(dyR) > 0.0) {\n            continue;\n          }\n\n          for (int iwC = 0; iwC < " + fSize + "; iwC++) {\n            float wC = float(iwC);\n            float dyC = (dyCCorner + wC) / " + origStride + ".0;\n\n            if (dyC < 0.0 || dyC >= " + dyCols + ".0 || fract(dyC) > 0.0) {\n              continue;\n            }\n\n            float dyValue = getDy(dyR, dyC, d);\n            float maxPosValue =\n                " + (fSize * fSize - 1) + ".0 - getMaxPos(dyR, dyC, d);\n\n            // Get the current value, check it against the value from the\n            // position matrix.\n            float curPosValue = wR * " + fSize + ".0 + wC;\n            float mask = float(maxPosValue == curPosValue ? 1.0 : 0.0);\n\n            dotProd += dyValue * mask;\n          }\n        }\n        setOutput(dotProd);\n      }\n    ";
    }
    return MaxPool2DBackpropProgram;
}());
exports.MaxPool2DBackpropProgram = MaxPool2DBackpropProgram;
//# sourceMappingURL=max_pool_backprop_gpu.js.map