"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ResizeBilinear3DProgram = (function () {
    function ResizeBilinear3DProgram(inputShape, outputDimensionsRowCol, alignCorners) {
        this.variableNames = ['A'];
        this.params = [];
        this.outputShape = [];
        var depth = inputShape[2];
        this.outputShape =
            [outputDimensionsRowCol[0], outputDimensionsRowCol[1], depth];
        this.params = [alignCorners];
        var effectiveInputShape = alignCorners ?
            [inputShape[0] - 1, inputShape[1] - 1, depth] :
            inputShape;
        var effectiveOutputShape = alignCorners ?
            [this.outputShape[0] - 1, this.outputShape[1] - 1, depth] :
            this.outputShape;
        this.userCode = "\n      const vec2 effectiveInputOverOutputRatioRC = vec2(\n          " + effectiveInputShape[0] / effectiveOutputShape[0] + ",\n          " + effectiveInputShape[1] / effectiveOutputShape[1] + ");\n      const vec2 inputShapeRC = vec2(" + inputShape[0] + ".0, " + inputShape[1] + ".0);\n\n      void main() {\n        vec3 coords = getOutputCoords();\n        vec2 yRC = coords.xy;\n        float d = coords.z;\n\n        // Fractional source index.\n        vec2 sourceFracIndexRC = yRC * effectiveInputOverOutputRatioRC;\n\n        // Compute the four integer indices.\n        vec2 sourceFloorRC = floor(sourceFracIndexRC);\n        vec2 sourceCeilRC = min(inputShapeRC - 1.0, ceil(sourceFracIndexRC));\n\n        float topLeft = getA(sourceFloorRC[0], sourceFloorRC[1], d);\n        float bottomLeft = getA(sourceCeilRC[0], sourceFloorRC[1], d);\n        float topRight = getA(sourceFloorRC[0], sourceCeilRC[1], d);\n        float bottomRight = getA(sourceCeilRC[0], sourceCeilRC[1], d);\n\n        vec2 fracRC = sourceFracIndexRC - sourceFloorRC;\n\n        float top = topLeft + (topRight - topLeft) * fracRC[1];\n        float bottom = bottomLeft + (bottomRight - bottomLeft) * fracRC[1];\n        float newValue = top + (bottom - top) * fracRC[0];\n\n        setOutput(newValue);\n      }\n    ";
    }
    return ResizeBilinear3DProgram;
}());
exports.ResizeBilinear3DProgram = ResizeBilinear3DProgram;
//# sourceMappingURL=resize_bilinear_gpu.js.map