"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var UnaryOp;
(function (UnaryOp) {
    UnaryOp[UnaryOp["EXP"] = 0] = "EXP";
    UnaryOp[UnaryOp["LOG"] = 1] = "LOG";
    UnaryOp[UnaryOp["NEG"] = 2] = "NEG";
    UnaryOp[UnaryOp["RELU"] = 3] = "RELU";
    UnaryOp[UnaryOp["SIGMOID"] = 4] = "SIGMOID";
    UnaryOp[UnaryOp["STEP"] = 5] = "STEP";
    UnaryOp[UnaryOp["SIN"] = 6] = "SIN";
    UnaryOp[UnaryOp["TANH"] = 7] = "TANH";
})(UnaryOp = exports.UnaryOp || (exports.UnaryOp = {}));
var UnaryOpProgram = (function () {
    function UnaryOpProgram(aShape, op) {
        this.variableNames = ['A'];
        this.outputShape = aShape;
        this.params = [op];
        this.userCode = "\n      void main() {\n        float v = getAAtOutCoords();\n        " + getOpSnippet(op) + "\n        setOutput(r);\n      }\n    ";
    }
    return UnaryOpProgram;
}());
exports.UnaryOpProgram = UnaryOpProgram;
function getOpSnippet(op) {
    switch (op) {
        case UnaryOp.EXP:
            return 'float r = exp(v);';
        case UnaryOp.LOG:
            return 'float r = log(v);';
        case UnaryOp.NEG:
            return 'float r = -v;';
        case UnaryOp.RELU:
            return 'float r = (v < 0.0) ? 0.0 : v;';
        case UnaryOp.SIGMOID:
            return 'float r = 1.0 / (1.0 + exp(-1.0 * v));';
        case UnaryOp.STEP:
            return 'float r = (v == v) ? (v > 0.0 ? 1.0 : 0.0) : v;';
        case UnaryOp.SIN:
            return 'float r = sin(v);';
        case UnaryOp.TANH:
            return "float e2x = exp(-2.0 * abs(v));\n              float r = sign(v) * (1.0 - e2x) / (1.0 + e2x);";
        default:
            throw Error('Unrecognized unary op type ' + op);
    }
}
//# sourceMappingURL=unaryop_gpu.js.map