"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var graph_util = require("../graph_util");
var util = require("../util");
var op_1 = require("./op");
var Split = (function (_super) {
    __extends(Split, _super);
    function Split(input, outputs) {
        var _this = _super.call(this) || this;
        _this.input = input;
        _this.outputs = outputs;
        outputs.forEach(function (output) {
            util.assertShapesMatch(input.shape, output.shape);
        });
        return _this;
    }
    Split.prototype.feedForward = function (math, inferenceArrays) {
        var inputArray = inferenceArrays.get(this.input);
        this.outputs.forEach(function (output) {
            inferenceArrays.set(output, inputArray);
        });
    };
    Split.prototype.backProp = function (math, inferenceArrays, gradientArrays) {
        var _this = this;
        if (!graph_util.shouldBackProp(this.input)) {
            return;
        }
        math.scope(function (keep) {
            var dx = math.add(gradientArrays.get(_this.outputs[0]), gradientArrays.get(_this.outputs[1]));
            _this.outputs.slice(2).forEach(function (output) {
                dx = math.add(dx, gradientArrays.get(output));
            });
            gradientArrays.set(_this.input, keep(dx));
        });
    };
    return Split;
}(op_1.Operation));
exports.Split = Split;
//# sourceMappingURL=split.js.map