import { Node, VariableNode } from './graph';
import { NDArrayMath } from './math/math';
import { SessionRuntime } from './session';
import { TensorArrayMap } from './tensor_array_map';
export declare abstract class Optimizer {
    protected variableNodes: VariableNode[];
    protected specifiedVariableNodes: VariableNode[] | null;
    constructor(specifiedVariableList?: Node[]);
    abstract beforeBatch(math: NDArrayMath, batchSize: number, runtime: SessionRuntime, activationArrayMap: TensorArrayMap, gradientArrayMap: TensorArrayMap): void;
    abstract afterExample(math: NDArrayMath, runtime: SessionRuntime, activationArrayMap: TensorArrayMap, gradientArrayMap: TensorArrayMap): void;
    abstract afterBatch(math: NDArrayMath, batchSize: number, runtime: SessionRuntime, activationArrayMap: TensorArrayMap, gradientArrayMap: TensorArrayMap): void;
    abstract dispose(): void;
}
