import { Node, Tensor, VariableNode } from './graph';
import { NDArrayMath } from './math/math';
import { Operation } from './ops/op';
import { FeedDictionary } from './session';
import { TensorArrayMap } from './tensor_array_map';
export declare function getTerminatingNodesFromFeedDictionary(feedDictionary: FeedDictionary): Node[];
export declare function getOrderedEvaluationSetFromEvalTensor(evalTensors: Tensor[], feedDictionary: FeedDictionary): Node[];
export declare function addPersistentArraysToTensorArrayMap(evaluationSet: Node[], tensorArrayMap: TensorArrayMap): void;
export declare function getVariableNodesFromEvaluationSet(evaluationSet: Node[]): VariableNode[];
export declare function throwIfFeedDictionaryContainsNDArrays(feedDictionary: FeedDictionary): void;
export declare function loadInputsFromFeedDictionaryToTensorArrayMap(batchFeed: FeedDictionary, activations: TensorArrayMap, math: NDArrayMath): void;
export declare function releaseFeedDictionaryInputsFromTensorArrayMap(batchFeed: FeedDictionary, activations: TensorArrayMap, math: NDArrayMath): void;
export declare function removeFeedDictionaryNodesFromEvaluationSet(feedDictionary: FeedDictionary, evaluationSet: Node[]): void;
export declare function disposeAndInitializeOperationOutputs(evaluationSet: Node[], tensorArrayMap: TensorArrayMap): void;
export declare function disposeAndInitializeOperationInputGradients(evaluationSet: Node[], gradients: TensorArrayMap): void;
export declare function disposeTransientOperationArrays(operations: Operation[], activations: TensorArrayMap, gradients: TensorArrayMap): void;
export declare function throwErrorIfEvaluationSetContainsPlaceholderNodes(evaluationSet: Node[]): void;
export declare function addSplitNodes(nodes: Node[]): Node[];
