import { Node } from './graph';
import { NDArrayMath } from './math/math';
import { Optimizer } from './optimizer';
import { SessionRuntime } from './session';
import { TensorArrayMap } from './tensor_array_map';
export declare class SGDOptimizer extends Optimizer {
    private learningRate;
    constructor(learningRate: number, specifiedVariableList?: Node[]);
    beforeBatch(math: NDArrayMath, batchSize: number, runtime: SessionRuntime, activationArrayMap: TensorArrayMap, gradientArrayMap: TensorArrayMap): void;
    afterExample(math: NDArrayMath, runtime: SessionRuntime, activationArrayMap: TensorArrayMap, gradientArrayMap: TensorArrayMap): void;
    afterBatch(math: NDArrayMath, batchSize: number, runtime: SessionRuntime, activationArrayMap: TensorArrayMap, gradientArrayMap: TensorArrayMap): void;
    dispose(): void;
    setLearningRate(learningRate: number): void;
    private variableGradients;
    private prevBatchSize;
    private one;
    private c;
}
