"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var TensorArrayMap = (function () {
    function TensorArrayMap() {
        this.dict = {};
    }
    TensorArrayMap.prototype.set = function (tensor, array) {
        this.dict[tensor.id] = array;
    };
    TensorArrayMap.prototype.get = function (tensor, skipChecks) {
        if (skipChecks === void 0) { skipChecks = false; }
        if (!skipChecks && this.dict[tensor.id] === undefined) {
            throw new Error('tensor ' + tensor.id + ' not in array map.');
        }
        var nda = this.dict[tensor.id];
        if (!skipChecks && nda === null) {
            throw new Error('tensor ' + tensor.id + ' has null array.');
        }
        return nda;
    };
    TensorArrayMap.prototype.delete = function (tensor) {
        delete this.dict[tensor.id];
    };
    TensorArrayMap.prototype.disposeArray = function (tensor) {
        if (this.dict[tensor.id] === undefined) {
            return;
        }
        var nda = this.dict[tensor.id];
        if (nda === null) {
            return;
        }
        nda.dispose();
        this.dict[tensor.id] = null;
    };
    TensorArrayMap.prototype.size = function () {
        return Object.keys(this.dict).length;
    };
    TensorArrayMap.prototype.dispose = function () {
        var _this = this;
        Object.keys(this.dict).forEach(function (tensorID) {
            var nda = _this.dict[+tensorID];
            if (nda) {
                nda.dispose();
            }
        });
        this.dict = {};
    };
    TensorArrayMap.prototype.hasNullArray = function (tensor) {
        if (this.dict[tensor.id] === undefined) {
            throw new Error('tensor ' + tensor.id + ' not in array map.');
        }
        return this.dict[tensor.id] === null;
    };
    return TensorArrayMap;
}());
exports.TensorArrayMap = TensorArrayMap;
//# sourceMappingURL=tensor_array_map.js.map