'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.removeAttribute = removeAttribute;
exports.setAttribute = setAttribute;

var _svgAttributeNamespace = require('svg-attribute-namespace');

var _svgAttributeNamespace2 = _interopRequireDefault(_svgAttributeNamespace);

var _element = require('../element');

var _indexOf = require('index-of');

var _indexOf2 = _interopRequireDefault(_indexOf);

var _setify = require('setify');

var _setify2 = _interopRequireDefault(_setify);

var _events = require('./events');

var _events2 = _interopRequireDefault(_events);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function removeAttribute(DOMElement, name, previousValue) {
  var eventType = _events2.default[name];
  if (eventType) {
    if (typeof previousValue === 'function') {
      DOMElement.removeEventListener(eventType, previousValue);
    }
    return;
  }
  switch (name) {
    case 'checked':
    case 'disabled':
    case 'selected':
      DOMElement[name] = false;
      break;
    case 'innerHTML':
    case 'nodeValue':
      DOMElement.innerHTML = '';
      break;
    case 'value':
      DOMElement.value = '';
      break;
    default:
      DOMElement.removeAttribute(name);
      break;
  }
}

function setAttribute(DOMElement, name, value, previousValue) {
  var eventType = _events2.default[name];
  if (value === previousValue) {
    return;
  }
  if (eventType) {
    if (typeof previousValue === 'function') {
      DOMElement.removeEventListener(eventType, previousValue);
    }
    DOMElement.addEventListener(eventType, value);
    return;
  }
  if (!(0, _element.isValidAttribute)(value)) {
    removeAttribute(DOMElement, name, previousValue);
    return;
  }
  switch (name) {
    case 'checked':
    case 'disabled':
    case 'innerHTML':
    case 'nodeValue':
      DOMElement[name] = value;
      break;
    case 'selected':
      DOMElement.selected = value;
      // Fix for IE/Safari where select is not correctly selected on change
      if (DOMElement.tagName === 'OPTION' && DOMElement.parentNode) {
        var select = DOMElement.parentNode;
        select.selectedIndex = (0, _indexOf2.default)(select.options, DOMElement);
      }
      break;
    case 'value':
      (0, _setify2.default)(DOMElement, value);
      break;
    default:
      DOMElement.setAttributeNS((0, _svgAttributeNamespace2.default)(name), name, value);
      break;
  }
}