'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _lodash = require('lodash.property');

var _lodash2 = _interopRequireDefault(_lodash);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _ = { property: _lodash2.default };

var deleteProperty = function deleteProperty(property) {
    var lastDotIndex = property.lastIndexOf('.');
    // Simple non-nested delete
    if (lastDotIndex === -1) {
        return function (obj) {
            // Return false for non-objects or non-existent props
            if (obj !== Object(obj) || !obj.hasOwnProperty(property)) return false;
            return delete obj[property];
        };
    }
    // Nested delete
    var objKey = property.substring(0, lastDotIndex);
    var propKey = property.substring(lastDotIndex + 1);
    return function (obj) {
        var prop = _.property(objKey)(obj);
        // Return false for non-existent props (and incidentally non-objects thx to _.property)
        if (!prop) return false;
        return delete prop[propKey];
    };
};

exports.default = deleteProperty;