# delete [![NPM version](https://img.shields.io/npm/v/delete.svg?style=flat)](https://www.npmjs.com/package/delete) [![NPM downloads](https://img.shields.io/npm/dm/delete.svg?style=flat)](https://npmjs.org/package/delete) [![Build Status](https://img.shields.io/travis/jonschlinkert/delete.svg?style=flat)](https://travis-ci.org/jonschlinkert/delete)

Delete files and folders and any intermediate directories if they exist (sync and async).

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install delete --save
```

## Usage

```js
var del = require('delete');

// async
del(['foo/*.js'], function(err) {
  if (err) throw err;
  console.log('done!');
});

// sync
del.sync(['foo/*.js']);

// promise
del.promise(['foo/*.js'])
  .then(function() {
    //=> do stuff
  });
```

## Options

All methods take an `options` object as the second argument.

### options.force

_(The `force` option was inspired by [grunt](http://gruntjs.com/).)_

An error is thrown if you try to delete files outside of the current working directory (cwd).

Override the default behavior:

```js
del.sync('../foo.md', {force: true});
```

## Related projects

You might also be interested in these projects:

* [copy](https://www.npmjs.com/package/copy): Copy files or directories using globs. | [homepage](https://github.com/jonschlinkert/copy)
* [export-files](https://www.npmjs.com/package/export-files): node.js utility for exporting a directory of files as modules. | [homepage](https://github.com/jonschlinkert/export-files)
* [micromatch](https://www.npmjs.com/package/micromatch): Glob matching for javascript/node.js. A drop-in replacement and faster alternative to minimatch and multimatch. | [homepage](https://github.com/jonschlinkert/micromatch)
* [write](https://www.npmjs.com/package/write): Write files to disk, creating intermediate directories if they don't exist. | [homepage](https://github.com/jonschlinkert/write)

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/delete/issues/new).

## Building docs

Generate readme and API documentation with [verb](https://github.com/verbose/verb):

```sh
$ npm install verb && npm run docs
```

Or, if [verb](https://github.com/verbose/verb) is installed globally:

```sh
$ verb
```

## Running tests

Install dev dependencies:

```sh
$ npm install -d && npm test
```

## Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2016, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT license](https://github.com/jonschlinkert/delete/blob/master/LICENSE).

***

_This file was generated by [verb](https://github.com/verbose/verb), v0.9.0, on April 27, 2016._