'use strict';

var $ = require('./helpers');

var cloneObj = require('./clone-obj');

var SCHEMA_URI = [
  'http://json-schema.org/schema#',
  'http://json-schema.org/schema',
  'http://json-schema.org/draft-04/schema#',
  'http://json-schema.org/draft-04/schema'
];

function expand(obj, parent, callback) {
  if (obj) {
    var id = typeof obj.id === 'string' ? obj.id : '#';

    if (!$.isURL(id)) {
      id = $.resolveURL(parent === id ? null : parent, id);
    }

    if (typeof obj.$ref === 'string' && !$.isURL(obj.$ref)) {
      obj.$ref = $.resolveURL(id, obj.$ref);
    }

    if (typeof obj.id === 'string') {
      obj.id = parent = id;
    }
  }

  for (var key in obj) {
    var value = obj[key];

    if (typeof value === 'object' && value !== null && !$.isKeyword(key)) {
      expand(value, parent, callback);
    }
  }

  if (typeof callback === 'function') {
    callback(obj);
  }
}

module.exports = function(fakeroot, schema, push) {
  if (typeof fakeroot === 'object') {
    push = schema;
    schema = fakeroot;
    fakeroot = null;
  }

  var base = fakeroot || '',
      copy = cloneObj(schema);

  if (copy.$schema && SCHEMA_URI.indexOf(copy.$schema) === -1) {
    throw new Error('Unsupported schema version (v4 only)');
  }

  base = $.resolveURL(copy.$schema || SCHEMA_URI[0], base);

  expand(copy, $.resolveURL(copy.id || '#', base), push);

  copy.id = copy.id || base;

  return copy;
};
