
function initTriggersOnInputFile(inputFileModuleId,urlWithContext){

	var strJsonFiles = $('#'+inputFileModuleId+'-dropzone .json').data("json");
	//var json = JSON.parse(strJsonFiles)
	makeFileList(strJsonFiles);

	$('#'+inputFileModuleId).fileupload({
			url: urlWithContext+'?action=uploadDocument|'+inputFileModuleId+'|UPLOAD|-1',
			autoUpload: true,
			sequentialUploads:true, //important pour éviter les concurrent exceptions
			dropZone: $('#'+inputFileModuleId+'-dropzone'),
			drop: function(e, data){
				devlog("drop ! "+data.length);
			},
			dragover: function(e, data){
				var dropZone = $('#'+inputFileModuleId+'-dropzone'),
					timeout = window.dropZoneTimeout;
				if (!timeout) {
					dropZone.addClass('in');
				} else {
					clearTimeout(timeout);
				}
				var found = false,
					node = e.target;
				do {
					if (node === dropZone[0]) {
						found = true;
						break;
					}
					node = node.parentNode;
				} while (node != null);
				if (found) {
					dropZone.addClass('hover');
				} else {
					dropZone.removeClass('hover');
				}
				window.dropZoneTimeout = setTimeout(function () {
					window.dropZoneTimeout = null;
					dropZone.removeClass('in hover');
				}, 100);
			},
			done: function (e, data) {
				devlog("Done !");
				$('#'+inputFileModuleId+'-upload-error-message').empty();

				if(data._response.result.status=="error"){

					$('#'+inputFileModuleId+'-upload-error-message').html(data._response.result.error).show();

				}else{

					/*
					 *  Récup. des images
					 */
					$('#'+inputFileModuleId+'-dropzone').empty();// vide les fichiers affichés de la dropzone


					if(data._response.result.lstFichierUpload != null
						&& data._response.result.lstFichierUpload.length > 0){

						//affichage des fichiers uploadés dans la dropzone

						makeFileList(data._response.result.lstFichierUpload);

					}

				}

				// reset de la progressbar
				$('#'+inputFileModuleId+'-progress .progress-bar').css('width','0%' );

				return;
			},
			fail: function(e, data) {
				//$("#${form.inputFileModulePhoto.id}-upload-error-message").empty().html("Erreur, la taille du fichier est trop grande. ").show();
				//debugger;
				var msgErreur = data._response.jqXHR.responseText;
				myAlert(msgErreur,"Erreur")



				$('#'+inputFileModuleId+'-progress .progress-bar').css(
					'width',
					0 + '%'
				);
				return;
			},
			progressall: function (e, data) {
				// devlog("Progressall ! "+data.loaded);
				var progress = parseInt(data.loaded / data.total * 100, 10);
				$('#'+inputFileModuleId+'-progress .progress-bar').css(
					'width',
					progress + '%'
				);
			},
			chunkFail: function(e, data){
				//data.errorThrown;

				devlog("ChunkFail !");
			},
			process: function(e, data){

				devlog("Process !");
			}

		}
	);


	function makeFileList(lstFichierUpload){

		$("#"+inputFileModuleId+"-dropzone").empty();// vide les fichiers affichés de la dropzone

		//affichage des fichiers uploadés dans la dropzone
		$(lstFichierUpload).each(function(index,el){



			var divImage = $("<div/>").addClass('upload-file').attr("data-id",index);
			var divImagePicto = $("<img/>").addClass('img-file-picto')
			.attr("src",urlWithContext+'?action=uploadDocument|'+inputFileModuleId+'|PICTO|'+index)
			.attr("alt","Picto "+el.infos.nom);
			var divImageName = $("<span/>").addClass('upload-file-name').html(el.infos.nom);
			divImage.append(divImagePicto).append(divImageName).appendTo("#"+inputFileModuleId+"-dropzone");

			// bouton REMOVE file
			if($("#"+inputFileModuleId).length == 1){ // vérifie que l'on ne soit pas en read-only

				var butImageRemoveIcon = $("<i/>").addClass('fas fa-times');
				var butImageRemove = $("<div/>").addClass('btn btn-sm').append(butImageRemoveIcon).appendTo(divImage);
				butImageRemove.click(function(){ removeFile(index)});
			}
			// liens pour download
			var linkToFileDownload = $("<a/>").attr("href",urlWithContext+'?action=uploadDocument|'+inputFileModuleId+'|DOWNLOAD|'+index);
			$(divImageName).wrap(linkToFileDownload);
			$(divImagePicto).wrap(linkToFileDownload);

		});

		// Affiche/masque le bouton d'upload en fonction
		var nbFilesMax = $("#"+inputFileModuleId).data("nb-files-max");
		var nbFiles = $(lstFichierUpload).length;

		if(nbFilesMax != -1 && nbFiles >= nbFilesMax){
			$("#"+inputFileModuleId+" .btn").hide();

		}else{
			$("#"+inputFileModuleId+" .btn").show();
		}

	}

	function removeFile(index){

		var url = urlWithContext+'?action=uploadDocument|'+inputFileModuleId+'|REMOVE_FILE|'+index;

		$.ajax({
			type: "POST",
			dataType: "json",
			contentType: "application/x-www-form-urlencoded; charset=UTF-8",
			url: url,
			success: function(dataJson) {

				/*
	        		 *  Récup. des images
	        		 */


				if(dataJson.lstFichierUpload != null){

					//affichage des fichiers uploadés dans la dropzone
					makeFileList(dataJson.lstFichierUpload);

				}

			},
			error: function(req, textStatus, errorThrown){
				//showLoading(false);
				myAlert(req.responseText,'Erreur', textStatus,'sm');
			}
		});

		// url: '${currentNavNode.urlWithContext}?action=uploadDocument|${form.inputFileModulePhoto.id}|REMOVE_FILE|'+index,
	}


	// If you want to allow specific drop zones
	// but disable the default browser action
	// for file drops on the document,
	// add the following JavaScript code:
	$(document).bind('drop dragover', function (e) {
		e.preventDefault();
	});



}
