/*!
 * devextreme-angular
 * Version: 17.1.4
 * Build date: Thu Jun 29 2017
 *
 * Copyright (c) 2012 - 2017 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var core_1 = require('@angular/core');
var nested_option_1 = require('../../core/nested-option');
var nested_option_2 = require('../../core/nested-option');
var constant_line_dxi_1 = require('./constant-line-dxi');
var strip_dxi_1 = require('./strip-dxi');
var DxoArgumentAxisComponent = (function (_super) {
    __extends(DxoArgumentAxisComponent, _super);
    function DxoArgumentAxisComponent(parentOptionHost, optionHost) {
        _super.call(this);
        parentOptionHost.setNestedOption(this);
        optionHost.setHost(this, this._fullOptionPath.bind(this));
    }
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "color", {
        get: function () {
            return this._getOption('color');
        },
        set: function (value) {
            this._setOption('color', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "constantLineStyle", {
        get: function () {
            return this._getOption('constantLineStyle');
        },
        set: function (value) {
            this._setOption('constantLineStyle', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "discreteAxisDivisionMode", {
        get: function () {
            return this._getOption('discreteAxisDivisionMode');
        },
        set: function (value) {
            this._setOption('discreteAxisDivisionMode', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "grid", {
        get: function () {
            return this._getOption('grid');
        },
        set: function (value) {
            this._setOption('grid', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "inverted", {
        get: function () {
            return this._getOption('inverted');
        },
        set: function (value) {
            this._setOption('inverted', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "label", {
        get: function () {
            return this._getOption('label');
        },
        set: function (value) {
            this._setOption('label', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "maxValueMargin", {
        get: function () {
            return this._getOption('maxValueMargin');
        },
        set: function (value) {
            this._setOption('maxValueMargin', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "minorGrid", {
        get: function () {
            return this._getOption('minorGrid');
        },
        set: function (value) {
            this._setOption('minorGrid', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "minorTick", {
        get: function () {
            return this._getOption('minorTick');
        },
        set: function (value) {
            this._setOption('minorTick', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "minValueMargin", {
        get: function () {
            return this._getOption('minValueMargin');
        },
        set: function (value) {
            this._setOption('minValueMargin', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "opacity", {
        get: function () {
            return this._getOption('opacity');
        },
        set: function (value) {
            this._setOption('opacity', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "placeholderSize", {
        get: function () {
            return this._getOption('placeholderSize');
        },
        set: function (value) {
            this._setOption('placeholderSize', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "setTicksAtUnitBeginning", {
        get: function () {
            return this._getOption('setTicksAtUnitBeginning');
        },
        set: function (value) {
            this._setOption('setTicksAtUnitBeginning', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "stripStyle", {
        get: function () {
            return this._getOption('stripStyle');
        },
        set: function (value) {
            this._setOption('stripStyle', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "tick", {
        get: function () {
            return this._getOption('tick');
        },
        set: function (value) {
            this._setOption('tick', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "title", {
        get: function () {
            return this._getOption('title');
        },
        set: function (value) {
            this._setOption('title', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "valueMarginsEnabled", {
        get: function () {
            return this._getOption('valueMarginsEnabled');
        },
        set: function (value) {
            this._setOption('valueMarginsEnabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "visible", {
        get: function () {
            return this._getOption('visible');
        },
        set: function (value) {
            this._setOption('visible', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "width", {
        get: function () {
            return this._getOption('width');
        },
        set: function (value) {
            this._setOption('width', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "argumentType", {
        get: function () {
            return this._getOption('argumentType');
        },
        set: function (value) {
            this._setOption('argumentType', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "axisDivisionFactor", {
        get: function () {
            return this._getOption('axisDivisionFactor');
        },
        set: function (value) {
            this._setOption('axisDivisionFactor', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "categories", {
        get: function () {
            return this._getOption('categories');
        },
        set: function (value) {
            this._setOption('categories', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "constantLines", {
        get: function () {
            return this._getOption('constantLines');
        },
        set: function (value) {
            this._setOption('constantLines', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "hoverMode", {
        get: function () {
            return this._getOption('hoverMode');
        },
        set: function (value) {
            this._setOption('hoverMode', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "logarithmBase", {
        get: function () {
            return this._getOption('logarithmBase');
        },
        set: function (value) {
            this._setOption('logarithmBase', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "max", {
        get: function () {
            return this._getOption('max');
        },
        set: function (value) {
            this._setOption('max', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "min", {
        get: function () {
            return this._getOption('min');
        },
        set: function (value) {
            this._setOption('min', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "minorTickCount", {
        get: function () {
            return this._getOption('minorTickCount');
        },
        set: function (value) {
            this._setOption('minorTickCount', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "minorTickInterval", {
        get: function () {
            return this._getOption('minorTickInterval');
        },
        set: function (value) {
            this._setOption('minorTickInterval', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "position", {
        get: function () {
            return this._getOption('position');
        },
        set: function (value) {
            this._setOption('position', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "strips", {
        get: function () {
            return this._getOption('strips');
        },
        set: function (value) {
            this._setOption('strips', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "tickInterval", {
        get: function () {
            return this._getOption('tickInterval');
        },
        set: function (value) {
            this._setOption('tickInterval', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "type", {
        get: function () {
            return this._getOption('type');
        },
        set: function (value) {
            this._setOption('type', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "firstPointOnStartAngle", {
        get: function () {
            return this._getOption('firstPointOnStartAngle');
        },
        set: function (value) {
            this._setOption('firstPointOnStartAngle', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "originValue", {
        get: function () {
            return this._getOption('originValue');
        },
        set: function (value) {
            this._setOption('originValue', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "period", {
        get: function () {
            return this._getOption('period');
        },
        set: function (value) {
            this._setOption('period', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "startAngle", {
        get: function () {
            return this._getOption('startAngle');
        },
        set: function (value) {
            this._setOption('startAngle', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "_optionPath", {
        get: function () {
            return 'argumentAxis';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "constantLinesChildren", {
        get: function () {
            return this._getOption('constantLines');
        },
        set: function (value) {
            this.setChildren('constantLines', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoArgumentAxisComponent.prototype, "stripsChildren", {
        get: function () {
            return this._getOption('strips');
        },
        set: function (value) {
            this.setChildren('strips', value);
        },
        enumerable: true,
        configurable: true
    });
    DxoArgumentAxisComponent.decorators = [
        { type: core_1.Component, args: [{
                    selector: 'dxo-argument-axis',
                    template: '',
                    styles: [''],
                    providers: [nested_option_1.NestedOptionHost]
                },] },
    ];
    DxoArgumentAxisComponent.ctorParameters = function () { return [
        { type: nested_option_1.NestedOptionHost, decorators: [{ type: core_1.SkipSelf }, { type: core_1.Host },] },
        { type: nested_option_1.NestedOptionHost, decorators: [{ type: core_1.Host },] },
    ]; };
    DxoArgumentAxisComponent.propDecorators = {
        'color': [{ type: core_1.Input },],
        'constantLineStyle': [{ type: core_1.Input },],
        'discreteAxisDivisionMode': [{ type: core_1.Input },],
        'grid': [{ type: core_1.Input },],
        'inverted': [{ type: core_1.Input },],
        'label': [{ type: core_1.Input },],
        'maxValueMargin': [{ type: core_1.Input },],
        'minorGrid': [{ type: core_1.Input },],
        'minorTick': [{ type: core_1.Input },],
        'minValueMargin': [{ type: core_1.Input },],
        'opacity': [{ type: core_1.Input },],
        'placeholderSize': [{ type: core_1.Input },],
        'setTicksAtUnitBeginning': [{ type: core_1.Input },],
        'stripStyle': [{ type: core_1.Input },],
        'tick': [{ type: core_1.Input },],
        'title': [{ type: core_1.Input },],
        'valueMarginsEnabled': [{ type: core_1.Input },],
        'visible': [{ type: core_1.Input },],
        'width': [{ type: core_1.Input },],
        'argumentType': [{ type: core_1.Input },],
        'axisDivisionFactor': [{ type: core_1.Input },],
        'categories': [{ type: core_1.Input },],
        'constantLines': [{ type: core_1.Input },],
        'hoverMode': [{ type: core_1.Input },],
        'logarithmBase': [{ type: core_1.Input },],
        'max': [{ type: core_1.Input },],
        'min': [{ type: core_1.Input },],
        'minorTickCount': [{ type: core_1.Input },],
        'minorTickInterval': [{ type: core_1.Input },],
        'position': [{ type: core_1.Input },],
        'strips': [{ type: core_1.Input },],
        'tickInterval': [{ type: core_1.Input },],
        'type': [{ type: core_1.Input },],
        'firstPointOnStartAngle': [{ type: core_1.Input },],
        'originValue': [{ type: core_1.Input },],
        'period': [{ type: core_1.Input },],
        'startAngle': [{ type: core_1.Input },],
        'constantLinesChildren': [{ type: core_1.ContentChildren, args: [core_1.forwardRef(function () { return constant_line_dxi_1.DxiConstantLineComponent; }),] },],
        'stripsChildren': [{ type: core_1.ContentChildren, args: [core_1.forwardRef(function () { return strip_dxi_1.DxiStripComponent; }),] },],
    };
    return DxoArgumentAxisComponent;
}(nested_option_2.NestedOption));
exports.DxoArgumentAxisComponent = DxoArgumentAxisComponent;
var DxoArgumentAxisModule = (function () {
    function DxoArgumentAxisModule() {
    }
    DxoArgumentAxisModule.decorators = [
        { type: core_1.NgModule, args: [{
                    declarations: [
                        DxoArgumentAxisComponent
                    ],
                    exports: [
                        DxoArgumentAxisComponent
                    ],
                },] },
    ];
    DxoArgumentAxisModule.ctorParameters = function () { return []; };
    return DxoArgumentAxisModule;
}());
exports.DxoArgumentAxisModule = DxoArgumentAxisModule;
//# sourceMappingURL=argument-axis.js.map