/*!
 * devextreme-angular
 * Version: 17.1.4
 * Build date: Thu Jun 29 2017
 *
 * Copyright (c) 2012 - 2017 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var core_1 = require('@angular/core');
var nested_option_1 = require('../../core/nested-option');
var popup_options_1 = require('./base/popup-options');
var toolbar_item_dxi_1 = require('./toolbar-item-dxi');
var DxoDropDownOptionsComponent = (function (_super) {
    __extends(DxoDropDownOptionsComponent, _super);
    function DxoDropDownOptionsComponent(parentOptionHost, optionHost) {
        _super.call(this);
        parentOptionHost.setNestedOption(this);
        optionHost.setHost(this, this._fullOptionPath.bind(this));
    }
    Object.defineProperty(DxoDropDownOptionsComponent.prototype, "_optionPath", {
        get: function () {
            return 'dropDownOptions';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxoDropDownOptionsComponent.prototype, "toolbarItemsChildren", {
        get: function () {
            return this._getOption('toolbarItems');
        },
        set: function (value) {
            this.setChildren('toolbarItems', value);
        },
        enumerable: true,
        configurable: true
    });
    DxoDropDownOptionsComponent.decorators = [
        { type: core_1.Component, args: [{
                    selector: 'dxo-drop-down-options',
                    template: '',
                    styles: [''],
                    providers: [nested_option_1.NestedOptionHost],
                    inputs: [
                        'onDisposing',
                        'onInitialized',
                        'onOptionChanged',
                        'elementAttr',
                        'height',
                        'rtlEnabled',
                        'width',
                        'accessKey',
                        'disabled',
                        'focusStateEnabled',
                        'hint',
                        'hoverStateEnabled',
                        'onContentReady',
                        'tabIndex',
                        'visible',
                        'animation',
                        'closeOnBackButton',
                        'closeOnOutsideClick',
                        'contentTemplate',
                        'deferRendering',
                        'dragEnabled',
                        'maxHeight',
                        'maxWidth',
                        'minHeight',
                        'minWidth',
                        'onHidden',
                        'onHiding',
                        'onShowing',
                        'onShown',
                        'shading',
                        'shadingColor',
                        'buttons',
                        'fullScreen',
                        'onResize',
                        'onResizeEnd',
                        'onResizeStart',
                        'onTitleRendered',
                        'resizeEnabled',
                        'showCloseButton',
                        'showTitle',
                        'title',
                        'titleTemplate',
                        'toolbarItems',
                        'position'
                    ]
                },] },
    ];
    DxoDropDownOptionsComponent.ctorParameters = function () { return [
        { type: nested_option_1.NestedOptionHost, decorators: [{ type: core_1.SkipSelf }, { type: core_1.Host },] },
        { type: nested_option_1.NestedOptionHost, decorators: [{ type: core_1.Host },] },
    ]; };
    DxoDropDownOptionsComponent.propDecorators = {
        'toolbarItemsChildren': [{ type: core_1.ContentChildren, args: [core_1.forwardRef(function () { return toolbar_item_dxi_1.DxiToolbarItemComponent; }),] },],
    };
    return DxoDropDownOptionsComponent;
}(popup_options_1.DxoPopupOptions));
exports.DxoDropDownOptionsComponent = DxoDropDownOptionsComponent;
var DxoDropDownOptionsModule = (function () {
    function DxoDropDownOptionsModule() {
    }
    DxoDropDownOptionsModule.decorators = [
        { type: core_1.NgModule, args: [{
                    declarations: [
                        DxoDropDownOptionsComponent
                    ],
                    exports: [
                        DxoDropDownOptionsComponent
                    ],
                },] },
    ];
    DxoDropDownOptionsModule.ctorParameters = function () { return []; };
    return DxoDropDownOptionsModule;
}());
exports.DxoDropDownOptionsModule = DxoDropDownOptionsModule;
//# sourceMappingURL=drop-down-options.js.map