/*!
 * devextreme-angular
 * Version: 17.1.4
 * Build date: Thu Jun 29 2017
 *
 * Copyright (c) 2012 - 2017 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var core_1 = require('@angular/core');
var nested_option_1 = require('../../core/nested-option');
var context_menu_item_dxi_1 = require('./base/context-menu-item-dxi');
var validation_rule_dxi_1 = require('./validation-rule-dxi');
var tab_dxi_1 = require('./tab-dxi');
var location_dxi_1 = require('./location-dxi');
var DxiItemComponent = (function (_super) {
    __extends(DxiItemComponent, _super);
    function DxiItemComponent(parentOptionHost, optionHost, element) {
        _super.call(this);
        this.element = element;
        parentOptionHost.setNestedOption(this);
        optionHost.setHost(this, this._fullOptionPath.bind(this));
    }
    Object.defineProperty(DxiItemComponent.prototype, "_optionPath", {
        get: function () {
            return 'items';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxiItemComponent.prototype, "itemsChildren", {
        get: function () {
            return this._getOption('items');
        },
        set: function (value) {
            this.setChildren('items', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxiItemComponent.prototype, "validationRulesChildren", {
        get: function () {
            return this._getOption('validationRules');
        },
        set: function (value) {
            this.setChildren('validationRules', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxiItemComponent.prototype, "tabsChildren", {
        get: function () {
            return this._getOption('tabs');
        },
        set: function (value) {
            this.setChildren('tabs', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxiItemComponent.prototype, "locationChildren", {
        get: function () {
            return this._getOption('location');
        },
        set: function (value) {
            this.setChildren('location', value);
        },
        enumerable: true,
        configurable: true
    });
    DxiItemComponent.prototype.ngAfterViewInit = function () {
        nested_option_1.extractTemplate(this, this.element);
    };
    DxiItemComponent.decorators = [
        { type: core_1.Component, args: [{
                    selector: 'dxi-item',
                    template: '<ng-content></ng-content>',
                    styles: [':host { display: block; }'],
                    providers: [nested_option_1.NestedOptionHost],
                    inputs: [
                        'disabled',
                        'html',
                        'template',
                        'text',
                        'visible',
                        'icon',
                        'iconSrc',
                        'title',
                        'onClick',
                        'type',
                        'baseSize',
                        'box',
                        'ratio',
                        'beginGroup',
                        'closeMenuOnClick',
                        'items',
                        'selectable',
                        'selected',
                        'colSpan',
                        'cssClass',
                        'itemType',
                        'name',
                        'visibleIndex',
                        'alignItemLabels',
                        'caption',
                        'colCount',
                        'colCountByScreen',
                        'dataField',
                        'editorOptions',
                        'editorType',
                        'helpText',
                        'isRequired',
                        'label',
                        'validationRules',
                        'tabPanelOptions',
                        'tabs',
                        'badge',
                        'tabTemplate',
                        'imageAlt',
                        'imageSrc',
                        'key',
                        'showChevron',
                        'titleTemplate',
                        'location',
                        'menuTemplate',
                        'heightRatio',
                        'widthRatio',
                        'locateInMenu',
                        'menuItemTemplate',
                        'options',
                        'showText',
                        'widget',
                        'expanded',
                        'hasItems',
                        'parentId'
                    ]
                },] },
    ];
    DxiItemComponent.ctorParameters = function () { return [
        { type: nested_option_1.NestedOptionHost, decorators: [{ type: core_1.SkipSelf }, { type: core_1.Host },] },
        { type: nested_option_1.NestedOptionHost, decorators: [{ type: core_1.Host },] },
        { type: core_1.ElementRef, },
    ]; };
    DxiItemComponent.propDecorators = {
        'itemsChildren': [{ type: core_1.ContentChildren, args: [core_1.forwardRef(function () { return DxiItemComponent; }),] },],
        'validationRulesChildren': [{ type: core_1.ContentChildren, args: [core_1.forwardRef(function () { return validation_rule_dxi_1.DxiValidationRuleComponent; }),] },],
        'tabsChildren': [{ type: core_1.ContentChildren, args: [core_1.forwardRef(function () { return tab_dxi_1.DxiTabComponent; }),] },],
        'locationChildren': [{ type: core_1.ContentChildren, args: [core_1.forwardRef(function () { return location_dxi_1.DxiLocationComponent; }),] },],
    };
    return DxiItemComponent;
}(context_menu_item_dxi_1.DxiContextMenuItem));
exports.DxiItemComponent = DxiItemComponent;
var DxiItemModule = (function () {
    function DxiItemModule() {
    }
    DxiItemModule.decorators = [
        { type: core_1.NgModule, args: [{
                    declarations: [
                        DxiItemComponent
                    ],
                    exports: [
                        DxiItemComponent
                    ],
                },] },
    ];
    DxiItemModule.ctorParameters = function () { return []; };
    return DxiItemModule;
}());
exports.DxiItemModule = DxiItemModule;
//# sourceMappingURL=item-dxi.js.map