/**
 * SVGs for elements are generated by the {@link GraphicsFactory}.
 *
 * This utility gives quick access to the important semantic
 * parts of an element.
 */

/**
 * Returns the visual part of a diagram element.
 *
 * @param {SVGElement} gfx
 *
 * @return {SVGElement}
 */
export function getVisual(gfx) {
  return gfx.childNodes[0];
}

/**
 * Returns the children for a given diagram element.
 *
 * @param {SVGElement} gfx
 * @return {SVGElement}
 */
export function getChildren(gfx) {
  return gfx.parentNode.childNodes[1];
}