import type { ChangeObject, AllDiffOptions, AbortableDiffOptions, DiffCallbackNonabortable, CallbackOptionAbortable, CallbackOptionNonabortable } from '../types.js';
export default class Diff<TokenT, ValueT extends Iterable<TokenT> = Iterable<TokenT>> {
    diff(oldStr: ValueT, newStr: ValueT, options: DiffCallbackNonabortable<ValueT>): undefined;
    diff(oldStr: ValueT, newStr: ValueT, options: AllDiffOptions & AbortableDiffOptions & CallbackOptionAbortable<ValueT>): undefined;
    diff(oldStr: ValueT, newStr: ValueT, options: AllDiffOptions & CallbackOptionNonabortable<ValueT>): undefined;
    diff(oldStr: ValueT, newStr: ValueT, options: AllDiffOptions & AbortableDiffOptions): ChangeObject<ValueT>[] | undefined;
    diff(oldStr: ValueT, newStr: ValueT, options?: AllDiffOptions): ChangeObject<ValueT>[];
    private diffWithOptionsObj;
    private addToPath;
    private extractCommon;
    equals(left: TokenT, right: TokenT, options: AllDiffOptions): boolean;
    removeEmpty(array: TokenT[]): TokenT[];
    castInput(value: ValueT, options: AllDiffOptions): ValueT;
    tokenize(value: ValueT, options: AllDiffOptions): TokenT[];
    join(chars: TokenT[]): ValueT;
    postProcess(changeObjects: ChangeObject<ValueT>[], options: AllDiffOptions): ChangeObject<ValueT>[];
    get useLongestToken(): boolean;
    private buildValues;
}
//# sourceMappingURL=base.d.ts.map