!function(modules){function __webpack_require__(moduleId){if(installedModules[moduleId])return installedModules[moduleId].exports;var module=installedModules[moduleId]={exports:{},id:moduleId,loaded:!1};return modules[moduleId].call(module.exports,module,module.exports,__webpack_require__),module.loaded=!0,module.exports}var installedModules={};return __webpack_require__.m=modules,__webpack_require__.c=installedModules,__webpack_require__.p="",__webpack_require__(0)}([function(module,exports,__webpack_require__){(function(global){!function(){function Diff2Html(){}var diffParser=__webpack_require__(1).DiffParser,fileLister=__webpack_require__(3).FileListPrinter,htmlPrinter=__webpack_require__(21).HtmlPrinter;Diff2Html.prototype.getJsonFromDiff=function(diffInput,config){var configOrEmpty=config||{};return diffParser.generateDiffJson(diffInput,configOrEmpty)},Diff2Html.prototype.getPrettyHtml=function(diffInput,config){var configOrEmpty=config||{},diffJson=diffInput;configOrEmpty.inputFormat&&"diff"!==configOrEmpty.inputFormat||(diffJson=diffParser.generateDiffJson(diffInput,configOrEmpty));var fileList="";configOrEmpty.showFiles===!0&&(fileList=fileLister.generateFileList(diffJson,configOrEmpty));var diffOutput="";return diffOutput="side-by-side"===configOrEmpty.outputFormat?htmlPrinter.generateSideBySideJsonHtml(diffJson,configOrEmpty):htmlPrinter.generateLineByLineJsonHtml(diffJson,configOrEmpty),fileList+diffOutput},Diff2Html.prototype.getPrettyHtmlFromDiff=function(diffInput,config){var configOrEmpty=config||{};return configOrEmpty.inputFormat="diff",configOrEmpty.outputFormat="line-by-line",this.getPrettyHtml(diffInput,configOrEmpty)},Diff2Html.prototype.getPrettyHtmlFromJson=function(diffJson,config){var configOrEmpty=config||{};return configOrEmpty.inputFormat="json",configOrEmpty.outputFormat="line-by-line",this.getPrettyHtml(diffJson,configOrEmpty)},Diff2Html.prototype.getPrettySideBySideHtmlFromDiff=function(diffInput,config){var configOrEmpty=config||{};return configOrEmpty.inputFormat="diff",configOrEmpty.outputFormat="side-by-side",this.getPrettyHtml(diffInput,configOrEmpty)},Diff2Html.prototype.getPrettySideBySideHtmlFromJson=function(diffJson,config){var configOrEmpty=config||{};return configOrEmpty.inputFormat="json",configOrEmpty.outputFormat="side-by-side",this.getPrettyHtml(diffJson,configOrEmpty)};var diffObject=new Diff2Html;module.exports.Diff2Html=diffObject,global.Diff2Html=diffObject}()}).call(exports,function(){return this}())},function(module,exports,__webpack_require__){!function(){function DiffParser(){}function getExtension(filename,language){var nameSplit=filename.split(".");return nameSplit.length>1?nameSplit[nameSplit.length-1]:language}function getSrcFilename(line,cfg){var prefixes=["a/","i/","w/","c/","o/"];return cfg.srcPrefix&&prefixes.push(cfg.srcPrefix),_getFilename("---",line,prefixes)}function getDstFilename(line,cfg){var prefixes=["b/","i/","w/","c/","o/"];return cfg.dstPrefix&&prefixes.push(cfg.dstPrefix),_getFilename("\\+\\+\\+",line,prefixes)}function _getFilename(linePrefix,line,prefixes){var filename,FilenameRegExp=new RegExp("^"+linePrefix+' "?(.+?)"?$'),values=FilenameRegExp.exec(line);if(values&&values[1]){filename=values[1];var matchingPrefixes=prefixes.filter(function(p){return 0===filename.indexOf(p)});matchingPrefixes[0]&&(filename=filename.slice(matchingPrefixes[0].length))}return filename}var utils=__webpack_require__(2).Utils,LINE_TYPE={INSERTS:"d2h-ins",DELETES:"d2h-del",INSERT_CHANGES:"d2h-ins d2h-change",DELETE_CHANGES:"d2h-del d2h-change",CONTEXT:"d2h-cntx",INFO:"d2h-info"};DiffParser.prototype.LINE_TYPE=LINE_TYPE,DiffParser.prototype.generateDiffJson=function(diffInput,config){var files=[],currentFile=null,currentBlock=null,oldLine=null,newLine=null,saveBlock=function(){currentBlock&&(currentFile.blocks.push(currentBlock),currentBlock=null)},saveFile=function(){currentFile&&currentFile.newName&&(files.push(currentFile),currentFile=null)},startFile=function(){saveBlock(),saveFile(),currentFile={},currentFile.blocks=[],currentFile.deletedLines=0,currentFile.addedLines=0},startBlock=function(line){saveBlock();var values;(values=/^@@ -(\d+),\d+ \+(\d+),\d+ @@.*/.exec(line))?currentFile.isCombined=!1:(values=/^@@@ -(\d+),\d+ -\d+,\d+ \+(\d+),\d+ @@@.*/.exec(line))?currentFile.isCombined=!0:(values=[0,0],currentFile.isCombined=!1),oldLine=values[1],newLine=values[2],currentBlock={},currentBlock.lines=[],currentBlock.oldStartLine=oldLine,currentBlock.newStartLine=newLine,currentBlock.header=line},createLine=function(line){var currentLine={};currentLine.content=line;var newLinePrefixes=currentFile.isCombined?["+"," +"]:["+"],delLinePrefixes=currentFile.isCombined?["-"," -"]:["-"];utils.startsWith(line,newLinePrefixes)?(currentFile.addedLines++,currentLine.type=LINE_TYPE.INSERTS,currentLine.oldNumber=null,currentLine.newNumber=newLine++,currentBlock.lines.push(currentLine)):utils.startsWith(line,delLinePrefixes)?(currentFile.deletedLines++,currentLine.type=LINE_TYPE.DELETES,currentLine.oldNumber=oldLine++,currentLine.newNumber=null,currentBlock.lines.push(currentLine)):(currentLine.type=LINE_TYPE.CONTEXT,currentLine.oldNumber=oldLine++,currentLine.newNumber=newLine++,currentBlock.lines.push(currentLine))},diffLines=diffInput.replace(/\\ No newline at end of file/g,"").replace(/\r\n?/g,"\n").split("\n"),oldMode=/^old mode (\d{6})/,newMode=/^new mode (\d{6})/,deletedFileMode=/^deleted file mode (\d{6})/,newFileMode=/^new file mode (\d{6})/,copyFrom=/^copy from "?(.+?)"?/,copyTo=/^copy to "?(.+?)"?/,renameFrom=/^rename from "?(.+?)"?/,renameTo=/^rename to "?(.+?)"?/,similarityIndex=/^similarity index (\d+)%/,dissimilarityIndex=/^dissimilarity index (\d+)%/,index=/^index ([0-9a-z]+)..([0-9a-z]+) (\d{6})?/,combinedIndex=/^index ([0-9a-z]+),([0-9a-z]+)..([0-9a-z]+)/,combinedMode=/^mode (\d{6}),(\d{6})..(\d{6})/,combinedNewFile=/^new file mode (\d{6})/,combinedDeletedFile=/^deleted file mode (\d{6}),(\d{6})/;return diffLines.forEach(function(line){if(line&&!utils.startsWith(line,"*")){var values=[];utils.startsWith(line,"diff")?startFile():currentFile&&!currentFile.oldName&&(values=getSrcFilename(line,config))?(currentFile.oldName=values,currentFile.language=getExtension(currentFile.oldName,currentFile.language)):currentFile&&!currentFile.newName&&(values=getDstFilename(line,config))?(currentFile.newName=values,currentFile.language=getExtension(currentFile.newName,currentFile.language)):currentFile&&utils.startsWith(line,"@@")?startBlock(line):(values=oldMode.exec(line))?currentFile.oldMode=values[1]:(values=newMode.exec(line))?currentFile.newMode=values[1]:(values=deletedFileMode.exec(line))?currentFile.deletedFileMode=values[1]:(values=newFileMode.exec(line))?currentFile.newFileMode=values[1]:(values=copyFrom.exec(line))?(currentFile.oldName=values[1],currentFile.isCopy=!0):(values=copyTo.exec(line))?(currentFile.newName=values[1],currentFile.isCopy=!0):(values=renameFrom.exec(line))?(currentFile.oldName=values[1],currentFile.isRename=!0):(values=renameTo.exec(line))?(currentFile.newName=values[1],currentFile.isRename=!0):(values=similarityIndex.exec(line))?currentFile.unchangedPercentage=values[1]:(values=dissimilarityIndex.exec(line))?currentFile.changedPercentage=values[1]:(values=index.exec(line))?(currentFile.checksumBefore=values[1],currentFile.checksumAfter=values[2],values[2]&&(currentFile.mode=values[3])):(values=combinedIndex.exec(line))?(currentFile.checksumBefore=[values[2],values[3]],currentFile.checksumAfter=values[1]):(values=combinedMode.exec(line))?(currentFile.oldMode=[values[2],values[3]],currentFile.newMode=values[1]):(values=combinedNewFile.exec(line))?currentFile.newFileMode=values[1]:(values=combinedDeletedFile.exec(line))?currentFile.deletedFileMode=values[1]:currentBlock&&createLine(line)}}),saveBlock(),saveFile(),files},module.exports.DiffParser=new DiffParser}()},function(module){!function(){function Utils(){}Utils.prototype.convertWhiteSpaceToNonBreakingSpace=function(str){return str.slice(0).replace(/ /g,"&nbsp;")},Utils.prototype.escape=function(str){return str.slice(0).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/\t/g,"    ")},Utils.prototype.startsWith=function(str,start){if("object"==typeof start){var result=!1;return start.forEach(function(s){0===str.indexOf(s)&&(result=!0)}),result}return 0===str.indexOf(start)},Utils.prototype.valueOrEmpty=function(value){return value?value:""},module.exports.Utils=new Utils}()},function(module,exports,__webpack_require__){!function(){function FileListPrinter(){}var printerUtils=__webpack_require__(4).PrinterUtils;FileListPrinter.prototype.generateFileList=function(diffFiles){return'<div class="d2h-file-list-wrapper">\n     <div class="d2h-file-list-header">\n         <span class="d2h-file-list-title">Files changed ('+diffFiles.length+')&nbsp&nbsp</span>\n         <a class="d2h-file-switch d2h-hide">hide</a>\n         <a class="d2h-file-switch d2h-show">show</a>\n     </div>\n     <table class="d2h-file-list">\n'+diffFiles.map(function(file){return'     <tr class="d2h-file-list-line">\n       <td class="d2h-lines-added">\n         <span>+'+file.addedLines+'</span>\n       </td>\n       <td class="d2h-lines-deleted">\n         <span>-'+file.deletedLines+'</span>\n       </td>\n       <td class="d2h-file-name-wrapper">\n         <a href="#'+printerUtils.getHtmlId(file)+'" class="d2h-file-name">&nbsp;'+printerUtils.getDiffName(file)+"         </a>\n       </td>\n     </tr>\n"}).join("\n")+"</table></div>\n"},module.exports.FileListPrinter=new FileListPrinter}()},function(module,exports,__webpack_require__){!function(){function PrinterUtils(){}function isDevNullName(name){return-1!==name.indexOf("dev/null")}function removeIns(line){return line.replace(/(<ins[^>]*>((.|\n)*?)<\/ins>)/g,"")}function removeDel(line){return line.replace(/(<del[^>]*>((.|\n)*?)<\/del>)/g,"")}var jsDiff=__webpack_require__(5),utils=__webpack_require__(2).Utils,Rematch=__webpack_require__(20).Rematch;PrinterUtils.prototype.getHtmlId=function(file){var hashCode=function(text){var i,chr,len,hash=0;if(0===text.length)return hash;for(i=0,len=text.length;len>i;i++)chr=text.charCodeAt(i),hash=(hash<<5)-hash+chr,hash|=0;return hash};return"d2h-"+hashCode(this.getDiffName(file)).toString().slice(-6)},PrinterUtils.prototype.getDiffName=function(file){var oldFilename=file.oldName,newFilename=file.newName;return oldFilename&&newFilename&&oldFilename!==newFilename&&!isDevNullName(oldFilename)&&!isDevNullName(newFilename)?oldFilename+" -> "+newFilename:newFilename&&!isDevNullName(newFilename)?newFilename:oldFilename?oldFilename:"Unknown filename"},PrinterUtils.prototype.diffHighlight=function(diffLine1,diffLine2,config){var linePrefix1,linePrefix2,unprefixedLine1,unprefixedLine2,prefixSize=1;config.isCombined&&(prefixSize=2),linePrefix1=diffLine1.substr(0,prefixSize),linePrefix2=diffLine2.substr(0,prefixSize),unprefixedLine1=diffLine1.substr(prefixSize),unprefixedLine2=diffLine2.substr(prefixSize);var diff;diff=config.charByChar?jsDiff.diffChars(unprefixedLine1,unprefixedLine2):jsDiff.diffWordsWithSpace(unprefixedLine1,unprefixedLine2);var highlightedLine="",changedWords=[];if(!config.charByChar&&"words"===config.matching){var treshold=.25;"undefined"!=typeof config.matchWordsThreshold&&(treshold=config.matchWordsThreshold);var matcher=Rematch.rematch(function(a,b){var amod=a.value,bmod=b.value;return Rematch.distance(amod,bmod)}),removed=diff.filter(function(element){return element.removed}),added=diff.filter(function(element){return element.added}),chunks=matcher(added,removed);chunks.forEach(function(chunk){if(1===chunk[0].length&&1===chunk[1].length){var dist=Rematch.distance(chunk[0][0].value,chunk[1][0].value);treshold>dist&&(changedWords.push(chunk[0][0]),changedWords.push(chunk[1][0]))}})}return diff.forEach(function(part){var addClass=changedWords.indexOf(part)>-1?' class="d2h-change"':"",elemType=part.added?"ins":part.removed?"del":null,escapedValue=utils.escape(part.value);highlightedLine+=null!==elemType?"<"+elemType+addClass+">"+escapedValue+"</"+elemType+">":escapedValue}),{first:{prefix:linePrefix1,line:removeIns(highlightedLine)},second:{prefix:linePrefix2,line:removeDel(highlightedLine)}}},module.exports.PrinterUtils=new PrinterUtils}()},function(module,exports,__webpack_require__){"use strict";function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{"default":obj}}exports.__esModule=!0,exports.canonicalize=exports.convertChangesToXML=exports.convertChangesToDMP=exports.parsePatch=exports.applyPatches=exports.applyPatch=exports.createPatch=exports.createTwoFilesPatch=exports.structuredPatch=exports.diffJson=exports.diffCss=exports.diffSentences=exports.diffTrimmedLines=exports.diffLines=exports.diffWordsWithSpace=exports.diffWords=exports.diffChars=exports.Diff=void 0;var _base=__webpack_require__(6),_base2=_interopRequireDefault(_base),_character=__webpack_require__(7),_word=__webpack_require__(8),_line=__webpack_require__(10),_sentence=__webpack_require__(11),_css=__webpack_require__(12),_json=__webpack_require__(13),_apply=__webpack_require__(14),_parse=__webpack_require__(15),_create=__webpack_require__(17),_dmp=__webpack_require__(18),_xml=__webpack_require__(19);exports.Diff=_base2["default"],exports.diffChars=_character.diffChars,exports.diffWords=_word.diffWords,exports.diffWordsWithSpace=_word.diffWordsWithSpace,exports.diffLines=_line.diffLines,exports.diffTrimmedLines=_line.diffTrimmedLines,exports.diffSentences=_sentence.diffSentences,exports.diffCss=_css.diffCss,exports.diffJson=_json.diffJson,exports.structuredPatch=_create.structuredPatch,exports.createTwoFilesPatch=_create.createTwoFilesPatch,exports.createPatch=_create.createPatch,exports.applyPatch=_apply.applyPatch,exports.applyPatches=_apply.applyPatches,exports.parsePatch=_parse.parsePatch,exports.convertChangesToDMP=_dmp.convertChangesToDMP,exports.convertChangesToXML=_xml.convertChangesToXML,exports.canonicalize=_json.canonicalize},function(module,exports){"use strict";function Diff(){}function buildValues(diff,components,newString,oldString,useLongestToken){for(var componentPos=0,componentLen=components.length,newPos=0,oldPos=0;componentLen>componentPos;componentPos++){var component=components[componentPos];if(component.removed){if(component.value=oldString.slice(oldPos,oldPos+component.count).join(""),oldPos+=component.count,componentPos&&components[componentPos-1].added){var tmp=components[componentPos-1];components[componentPos-1]=components[componentPos],components[componentPos]=tmp}}else{if(!component.added&&useLongestToken){var value=newString.slice(newPos,newPos+component.count);value=value.map(function(value,i){var oldValue=oldString[oldPos+i];return oldValue.length>value.length?oldValue:value}),component.value=value.join("")}else component.value=newString.slice(newPos,newPos+component.count).join("");newPos+=component.count,component.added||(oldPos+=component.count)}}var lastComponent=components[componentLen-1];return componentLen>1&&(lastComponent.added||lastComponent.removed)&&diff.equals("",lastComponent.value)&&(components[componentLen-2].value+=lastComponent.value,components.pop()),components}function clonePath(path){return{newPos:path.newPos,components:path.components.slice(0)}}exports.__esModule=!0,exports["default"]=Diff,Diff.prototype={diff:function(oldString,newString){function done(value){return callback?(setTimeout(function(){callback(void 0,value)},0),!0):value}function execEditLength(){for(var diagonalPath=-1*editLength;editLength>=diagonalPath;diagonalPath+=2){var basePath=void 0,addPath=bestPath[diagonalPath-1],removePath=bestPath[diagonalPath+1],_oldPos=(removePath?removePath.newPos:0)-diagonalPath;addPath&&(bestPath[diagonalPath-1]=void 0);var canAdd=addPath&&addPath.newPos+1<newLen,canRemove=removePath&&_oldPos>=0&&oldLen>_oldPos;if(canAdd||canRemove){if(!canAdd||canRemove&&addPath.newPos<removePath.newPos?(basePath=clonePath(removePath),self.pushComponent(basePath.components,void 0,!0)):(basePath=addPath,basePath.newPos++,self.pushComponent(basePath.components,!0,void 0)),_oldPos=self.extractCommon(basePath,newString,oldString,diagonalPath),basePath.newPos+1>=newLen&&_oldPos+1>=oldLen)return done(buildValues(self,basePath.components,newString,oldString,self.useLongestToken));bestPath[diagonalPath]=basePath}else bestPath[diagonalPath]=void 0}editLength++}var options=arguments.length<=2||void 0===arguments[2]?{}:arguments[2],callback=options.callback;"function"==typeof options&&(callback=options,options={}),this.options=options;var self=this;oldString=this.castInput(oldString),newString=this.castInput(newString),oldString=this.removeEmpty(this.tokenize(oldString)),newString=this.removeEmpty(this.tokenize(newString));var newLen=newString.length,oldLen=oldString.length,editLength=1,maxEditLength=newLen+oldLen,bestPath=[{newPos:-1,components:[]}],oldPos=this.extractCommon(bestPath[0],newString,oldString,0);if(bestPath[0].newPos+1>=newLen&&oldPos+1>=oldLen)return done([{value:newString.join(""),count:newString.length}]);if(callback)!function exec(){setTimeout(function(){return editLength>maxEditLength?callback():void(execEditLength()||exec())},0)}();else for(;maxEditLength>=editLength;){var ret=execEditLength();if(ret)return ret}},pushComponent:function(components,added,removed){var last=components[components.length-1];last&&last.added===added&&last.removed===removed?components[components.length-1]={count:last.count+1,added:added,removed:removed}:components.push({count:1,added:added,removed:removed})},extractCommon:function(basePath,newString,oldString,diagonalPath){for(var newLen=newString.length,oldLen=oldString.length,newPos=basePath.newPos,oldPos=newPos-diagonalPath,commonCount=0;newLen>newPos+1&&oldLen>oldPos+1&&this.equals(newString[newPos+1],oldString[oldPos+1]);)newPos++,oldPos++,commonCount++;return commonCount&&basePath.components.push({count:commonCount}),basePath.newPos=newPos,oldPos},equals:function(left,right){return left===right},removeEmpty:function(array){for(var ret=[],i=0;i<array.length;i++)array[i]&&ret.push(array[i]);return ret},castInput:function(value){return value},tokenize:function(value){return value.split("")}}},function(module,exports,__webpack_require__){"use strict";function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{"default":obj}}function diffChars(oldStr,newStr,callback){return characterDiff.diff(oldStr,newStr,callback)}exports.__esModule=!0,exports.characterDiff=void 0,exports.diffChars=diffChars;var _base=__webpack_require__(6),_base2=_interopRequireDefault(_base),characterDiff=exports.characterDiff=new _base2["default"]},function(module,exports,__webpack_require__){"use strict";function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{"default":obj}}function diffWords(oldStr,newStr,callback){var options=_params.generateOptions(callback,{ignoreWhitespace:!0});return wordDiff.diff(oldStr,newStr,options)}function diffWordsWithSpace(oldStr,newStr,callback){return wordDiff.diff(oldStr,newStr,callback)}exports.__esModule=!0,exports.wordDiff=void 0,exports.diffWords=diffWords,exports.diffWordsWithSpace=diffWordsWithSpace;var _base=__webpack_require__(6),_base2=_interopRequireDefault(_base),_params=__webpack_require__(9),extendedWordChars=/^[A-Za-z\xC0-\u02C6\u02C8-\u02D7\u02DE-\u02FF\u1E00-\u1EFF]+$/,reWhitespace=/\S/,wordDiff=exports.wordDiff=new _base2["default"];wordDiff.equals=function(left,right){return left===right||this.options.ignoreWhitespace&&!reWhitespace.test(left)&&!reWhitespace.test(right)},wordDiff.tokenize=function(value){for(var tokens=value.split(/(\s+|\b)/),i=0;i<tokens.length-1;i++)!tokens[i+1]&&tokens[i+2]&&extendedWordChars.test(tokens[i])&&extendedWordChars.test(tokens[i+2])&&(tokens[i]+=tokens[i+2],tokens.splice(i+1,2),i--);return tokens}},function(module,exports){"use strict";function generateOptions(options,defaults){if("function"==typeof options)defaults.callback=options;else if(options)for(var name in options)options.hasOwnProperty(name)&&(defaults[name]=options[name]);return defaults}exports.__esModule=!0,exports.generateOptions=generateOptions},function(module,exports,__webpack_require__){"use strict";function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{"default":obj}}function diffLines(oldStr,newStr,callback){return lineDiff.diff(oldStr,newStr,callback)}function diffTrimmedLines(oldStr,newStr,callback){var options=_params.generateOptions(callback,{ignoreWhitespace:!0});return lineDiff.diff(oldStr,newStr,options)}exports.__esModule=!0,exports.lineDiff=void 0,exports.diffLines=diffLines,exports.diffTrimmedLines=diffTrimmedLines;var _base=__webpack_require__(6),_base2=_interopRequireDefault(_base),_params=__webpack_require__(9),lineDiff=exports.lineDiff=new _base2["default"];lineDiff.tokenize=function(value){var retLines=[],linesAndNewlines=value.split(/(\n|\r\n)/);linesAndNewlines[linesAndNewlines.length-1]||linesAndNewlines.pop();for(var i=0;i<linesAndNewlines.length;i++){var line=linesAndNewlines[i];i%2&&!this.options.newlineIsToken?retLines[retLines.length-1]+=line:(this.options.ignoreWhitespace&&(line=line.trim()),retLines.push(line))}return retLines}},function(module,exports,__webpack_require__){"use strict";function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{"default":obj}}function diffSentences(oldStr,newStr,callback){return sentenceDiff.diff(oldStr,newStr,callback)}exports.__esModule=!0,exports.sentenceDiff=void 0,exports.diffSentences=diffSentences;var _base=__webpack_require__(6),_base2=_interopRequireDefault(_base),sentenceDiff=exports.sentenceDiff=new _base2["default"];sentenceDiff.tokenize=function(value){return value.split(/(\S.+?[.!?])(?=\s+|$)/)}},function(module,exports,__webpack_require__){"use strict";function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{"default":obj}}function diffCss(oldStr,newStr,callback){return cssDiff.diff(oldStr,newStr,callback)}exports.__esModule=!0,exports.cssDiff=void 0,exports.diffCss=diffCss;var _base=__webpack_require__(6),_base2=_interopRequireDefault(_base),cssDiff=exports.cssDiff=new _base2["default"];cssDiff.tokenize=function(value){return value.split(/([{}:;,]|\s+)/)}},function(module,exports,__webpack_require__){"use strict";function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{"default":obj}}function diffJson(oldObj,newObj,callback){return jsonDiff.diff(oldObj,newObj,callback)}function canonicalize(obj,stack,replacementStack){stack=stack||[],replacementStack=replacementStack||[];var i=void 0;for(i=0;i<stack.length;i+=1)if(stack[i]===obj)return replacementStack[i];var canonicalizedObj=void 0;if("[object Array]"===objectPrototypeToString.call(obj)){for(stack.push(obj),canonicalizedObj=new Array(obj.length),replacementStack.push(canonicalizedObj),i=0;i<obj.length;i+=1)canonicalizedObj[i]=canonicalize(obj[i],stack,replacementStack);return stack.pop(),replacementStack.pop(),canonicalizedObj}if(obj&&obj.toJSON&&(obj=obj.toJSON()),"object"===("undefined"==typeof obj?"undefined":_typeof(obj))&&null!==obj){stack.push(obj),canonicalizedObj={},replacementStack.push(canonicalizedObj);var sortedKeys=[],key=void 0;for(key in obj)obj.hasOwnProperty(key)&&sortedKeys.push(key);for(sortedKeys.sort(),i=0;i<sortedKeys.length;i+=1)key=sortedKeys[i],canonicalizedObj[key]=canonicalize(obj[key],stack,replacementStack);stack.pop(),replacementStack.pop()}else canonicalizedObj=obj;return canonicalizedObj}exports.__esModule=!0,exports.jsonDiff=void 0;var _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol?"symbol":typeof obj};exports.diffJson=diffJson,exports.canonicalize=canonicalize;var _base=__webpack_require__(6),_base2=_interopRequireDefault(_base),_line=__webpack_require__(10),objectPrototypeToString=Object.prototype.toString,jsonDiff=exports.jsonDiff=new _base2["default"];jsonDiff.useLongestToken=!0,jsonDiff.tokenize=_line.lineDiff.tokenize,jsonDiff.castInput=function(value){return"string"==typeof value?value:JSON.stringify(canonicalize(value),void 0,"  ")},jsonDiff.equals=function(left,right){return _base2["default"].prototype.equals(left.replace(/,([\r\n])/g,"$1"),right.replace(/,([\r\n])/g,"$1"))}},function(module,exports,__webpack_require__){"use strict";function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{"default":obj}}function applyPatch(source,uniDiff){function hunkFits(hunk,toPos){for(var j=0;j<hunk.lines.length;j++){var line=hunk.lines[j],operation=line[0],content=line.substr(1);if(" "===operation||"-"===operation){if(!compareLine(toPos+1,lines[toPos],operation,content)&&(errorCount++,errorCount>fuzzFactor))return!1;toPos++}}return!0}var options=arguments.length<=2||void 0===arguments[2]?{}:arguments[2];if("string"==typeof uniDiff&&(uniDiff=_parse.parsePatch(uniDiff)),Array.isArray(uniDiff)){if(uniDiff.length>1)throw new Error("applyPatch only works with a single input.");uniDiff=uniDiff[0]}for(var lines=source.split("\n"),hunks=uniDiff.hunks,compareLine=options.compareLine||function(lineNumber,line,operation,patchContent){return line===patchContent},errorCount=0,fuzzFactor=options.fuzzFactor||0,minLine=0,offset=0,removeEOFNL=void 0,addEOFNL=void 0,i=0;i<hunks.length;i++){for(var hunk=hunks[i],maxLine=lines.length-hunk.oldLines,localOffset=0,toPos=offset+hunk.oldStart-1,iterator=_distanceIterator2["default"](toPos,minLine,maxLine);void 0!==localOffset;localOffset=iterator())if(hunkFits(hunk,toPos+localOffset)){hunk.offset=offset+=localOffset;break}if(void 0===localOffset)return!1;minLine=hunk.offset+hunk.oldStart+hunk.oldLines}for(var _i=0;_i<hunks.length;_i++)for(var _hunk=hunks[_i],_toPos=_hunk.offset+_hunk.newStart-1,j=0;j<_hunk.lines.length;j++){var line=_hunk.lines[j],operation=line[0],content=line.substr(1);if(" "===operation)_toPos++;else if("-"===operation)lines.splice(_toPos,1);else if("+"===operation)lines.splice(_toPos,0,content),_toPos++;else if("\\"===operation){var previousOperation=_hunk.lines[j-1]?_hunk.lines[j-1][0]:null;"+"===previousOperation?removeEOFNL=!0:"-"===previousOperation&&(addEOFNL=!0)}}if(removeEOFNL)for(;!lines[lines.length-1];)lines.pop();else addEOFNL&&lines.push("");return lines.join("\n")}function applyPatches(uniDiff,options){function processIndex(){var index=uniDiff[currentIndex++];return index?void options.loadFile(index,function(err,data){if(err)return options.complete(err);var updatedContent=applyPatch(data,index,options);options.patched(index,updatedContent),setTimeout(processIndex,0)}):options.complete()}"string"==typeof uniDiff&&(uniDiff=_parse.parsePatch(uniDiff));var currentIndex=0;processIndex()}exports.__esModule=!0,exports.applyPatch=applyPatch,exports.applyPatches=applyPatches;var _parse=__webpack_require__(15),_distanceIterator=__webpack_require__(16),_distanceIterator2=_interopRequireDefault(_distanceIterator)},function(module,exports){"use strict";function parsePatch(uniDiff){function parseIndex(){var index={};for(list.push(index);i<diffstr.length;){var line=diffstr[i];if(/^(\-\-\-|\+\+\+|@@)\s/.test(line))break;var header=/^(?:Index:|diff(?: -r \w+)+)\s+(.+?)\s*$/.exec(line);header&&(index.index=header[1]),i++}for(parseFileHeader(index),parseFileHeader(index),index.hunks=[];i<diffstr.length;){var _line=diffstr[i];if(/^(Index:|diff|\-\-\-|\+\+\+)\s/.test(_line))break;if(/^@@/.test(_line))index.hunks.push(parseHunk());else{if(_line&&options.strict)throw new Error("Unknown line "+(i+1)+" "+JSON.stringify(_line));i++}}}function parseFileHeader(index){var fileHeader=/^(\-\-\-|\+\+\+)\s+(\S*)\s?(.*?)\s*$/.exec(diffstr[i]);if(fileHeader){var keyPrefix="---"===fileHeader[1]?"old":"new";index[keyPrefix+"FileName"]=fileHeader[2],index[keyPrefix+"Header"]=fileHeader[3],i++}}function parseHunk(){for(var chunkHeaderIndex=i,chunkHeaderLine=diffstr[i++],chunkHeader=chunkHeaderLine.split(/@@ -(\d+)(?:,(\d+))? \+(\d+)(?:,(\d+))? @@/),hunk={oldStart:+chunkHeader[1],oldLines:+chunkHeader[2]||1,newStart:+chunkHeader[3],newLines:+chunkHeader[4]||1,lines:[]},addCount=0,removeCount=0;i<diffstr.length;i++){var operation=diffstr[i][0];if("+"!==operation&&"-"!==operation&&" "!==operation&&"\\"!==operation)break;hunk.lines.push(diffstr[i]),"+"===operation?addCount++:"-"===operation?removeCount++:" "===operation&&(addCount++,removeCount++)}if(addCount||1!==hunk.newLines||(hunk.newLines=0),removeCount||1!==hunk.oldLines||(hunk.oldLines=0),options.strict){if(addCount!==hunk.newLines)throw new Error("Added line count did not match for hunk at line "+(chunkHeaderIndex+1));if(removeCount!==hunk.oldLines)throw new Error("Removed line count did not match for hunk at line "+(chunkHeaderIndex+1))}return hunk}for(var options=arguments.length<=1||void 0===arguments[1]?{}:arguments[1],diffstr=uniDiff.split("\n"),list=[],i=0;i<diffstr.length;)parseIndex();return list}exports.__esModule=!0,exports.parsePatch=parsePatch},function(module,exports){"use strict";exports.__esModule=!0,exports["default"]=function(start,minLine,maxLine){var wantForward=!0,backwardExhausted=!1,forwardExhausted=!1,localOffset=1;return function iterator(){if(wantForward&&!forwardExhausted){if(backwardExhausted?localOffset++:wantForward=!1,maxLine>=start+localOffset)return localOffset;forwardExhausted=!0}return backwardExhausted?void 0:(forwardExhausted||(wantForward=!0),start-localOffset>=minLine?-localOffset++:(backwardExhausted=!0,iterator()))}}},function(module,exports,__webpack_require__){"use strict";function _toConsumableArray(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++)arr2[i]=arr[i];return arr2}return Array.from(arr)}function structuredPatch(oldFileName,newFileName,oldStr,newStr,oldHeader,newHeader,options){function contextLines(lines){return lines.map(function(entry){return" "+entry})}options||(options={context:4});var diff=_line.diffLines(oldStr,newStr);diff.push({value:"",lines:[]});for(var hunks=[],oldRangeStart=0,newRangeStart=0,curRange=[],oldLine=1,newLine=1,_loop=function(i){var current=diff[i],lines=current.lines||current.value.replace(/\n$/,"").split("\n");if(current.lines=lines,current.added||current.removed){var _curRange;if(!oldRangeStart){var prev=diff[i-1];oldRangeStart=oldLine,newRangeStart=newLine,prev&&(curRange=options.context>0?contextLines(prev.lines.slice(-options.context)):[],oldRangeStart-=curRange.length,newRangeStart-=curRange.length)}(_curRange=curRange).push.apply(_curRange,_toConsumableArray(lines.map(function(entry){return(current.added?"+":"-")+entry}))),current.added?newLine+=lines.length:oldLine+=lines.length}else{if(oldRangeStart)if(lines.length<=2*options.context&&i<diff.length-2){var _curRange2;(_curRange2=curRange).push.apply(_curRange2,_toConsumableArray(contextLines(lines)))}else{var _curRange3,contextSize=Math.min(lines.length,options.context);(_curRange3=curRange).push.apply(_curRange3,_toConsumableArray(contextLines(lines.slice(0,contextSize))));var hunk={oldStart:oldRangeStart,oldLines:oldLine-oldRangeStart+contextSize,newStart:newRangeStart,newLines:newLine-newRangeStart+contextSize,lines:curRange};if(i>=diff.length-2&&lines.length<=options.context){var oldEOFNewline=/\n$/.test(oldStr),newEOFNewline=/\n$/.test(newStr);0!=lines.length||oldEOFNewline?oldEOFNewline&&newEOFNewline||curRange.push("\\ No newline at end of file"):curRange.splice(hunk.oldLines,0,"\\ No newline at end of file")}hunks.push(hunk),oldRangeStart=0,newRangeStart=0,curRange=[]}oldLine+=lines.length,newLine+=lines.length}},i=0;i<diff.length;i++)_loop(i);return{oldFileName:oldFileName,newFileName:newFileName,oldHeader:oldHeader,newHeader:newHeader,hunks:hunks}}function createTwoFilesPatch(oldFileName,newFileName,oldStr,newStr,oldHeader,newHeader,options){var diff=structuredPatch(oldFileName,newFileName,oldStr,newStr,oldHeader,newHeader,options),ret=[];oldFileName==newFileName&&ret.push("Index: "+oldFileName),ret.push("==================================================================="),
ret.push("--- "+diff.oldFileName+("undefined"==typeof diff.oldHeader?"":"	"+diff.oldHeader)),ret.push("+++ "+diff.newFileName+("undefined"==typeof diff.newHeader?"":"	"+diff.newHeader));for(var i=0;i<diff.hunks.length;i++){var hunk=diff.hunks[i];ret.push("@@ -"+hunk.oldStart+","+hunk.oldLines+" +"+hunk.newStart+","+hunk.newLines+" @@"),ret.push.apply(ret,hunk.lines)}return ret.join("\n")+"\n"}function createPatch(fileName,oldStr,newStr,oldHeader,newHeader,options){return createTwoFilesPatch(fileName,fileName,oldStr,newStr,oldHeader,newHeader,options)}exports.__esModule=!0,exports.structuredPatch=structuredPatch,exports.createTwoFilesPatch=createTwoFilesPatch,exports.createPatch=createPatch;var _line=__webpack_require__(10)},function(module,exports){"use strict";function convertChangesToDMP(changes){for(var ret=[],change=void 0,operation=void 0,i=0;i<changes.length;i++)change=changes[i],operation=change.added?1:change.removed?-1:0,ret.push([operation,change.value]);return ret}exports.__esModule=!0,exports.convertChangesToDMP=convertChangesToDMP},function(module,exports){"use strict";function convertChangesToXML(changes){for(var ret=[],i=0;i<changes.length;i++){var change=changes[i];change.added?ret.push("<ins>"):change.removed&&ret.push("<del>"),ret.push(escapeHTML(change.value)),change.added?ret.push("</ins>"):change.removed&&ret.push("</del>")}return ret.join("")}function escapeHTML(s){var n=s;return n=n.replace(/&/g,"&amp;"),n=n.replace(/</g,"&lt;"),n=n.replace(/>/g,"&gt;"),n=n.replace(/"/g,"&quot;")}exports.__esModule=!0,exports.convertChangesToXML=convertChangesToXML},function(module){!function(){function levenshtein(a,b){if(0==a.length)return b.length;if(0==b.length)return a.length;var i,matrix=[];for(i=0;i<=b.length;i++)matrix[i]=[i];var j;for(j=0;j<=a.length;j++)matrix[0][j]=j;for(i=1;i<=b.length;i++)for(j=1;j<=a.length;j++)matrix[i][j]=b.charAt(i-1)==a.charAt(j-1)?matrix[i-1][j-1]:Math.min(matrix[i-1][j-1]+1,Math.min(matrix[i][j-1]+1,matrix[i-1][j]+1));return matrix[b.length][a.length]}var Rematch={};Rematch.arrayToString=function arrayToString(a){return"[object Array]"===Object.prototype.toString.apply(a,[])?"["+a.map(arrayToString).join(", ")+"]":a},Rematch.levenshtein=levenshtein,Rematch.distance=function(x,y){x=x.trim(),y=y.trim();var lev=levenshtein(x,y),score=lev/(x.length+y.length);return score},Rematch.rematch=function(distanceFunction){function findBestMatch(a,b,cache){var cachecount=0;for(var key in cache)cachecount++;for(var bestMatch,bestMatchDist=1/0,i=0;i<a.length;++i)for(var j=0;j<b.length;++j){var md,cacheKey=JSON.stringify([a[i],b[j]]);cache.hasOwnProperty(cacheKey)?md=cache[cacheKey]:(md=distanceFunction(a[i],b[j]),cache[cacheKey]=md),bestMatchDist>md&&(bestMatchDist=md,bestMatch={indexA:i,indexB:j,score:bestMatchDist})}return bestMatch}function group(a,b,level,cache){"undefined"==typeof cache&&(cache={});var bm=findBestMatch(a,b,cache);if(level||(level=0),!bm||a.length+b.length<3)return[[a,b]];var a1=a.slice(0,bm.indexA),b1=b.slice(0,bm.indexB),aMatch=[a[bm.indexA]],bMatch=[b[bm.indexB]],tailA=bm.indexA+1,tailB=bm.indexB+1,a2=a.slice(tailA),b2=b.slice(tailB),group1=group(a1,b1,level+1,cache),groupMatch=group(aMatch,bMatch,level+1,cache),group2=group(a2,b2,level+1,cache),result=groupMatch;return(bm.indexA>0||bm.indexB>0)&&(result=group1.concat(result)),(a.length>tailA||b.length>tailB)&&(result=result.concat(group2)),result}return group},module.exports.Rematch=Rematch}()},function(module,exports,__webpack_require__){!function(){function HtmlPrinter(){}var LineByLinePrinter=__webpack_require__(22).LineByLinePrinter,SideBySidePrinter=__webpack_require__(39).SideBySidePrinter;HtmlPrinter.prototype.generateLineByLineJsonHtml=function(diffFiles,config){var lineByLinePrinter=new LineByLinePrinter(config);return lineByLinePrinter.generateLineByLineJsonHtml(diffFiles)},HtmlPrinter.prototype.generateSideBySideJsonHtml=function(diffFiles,config){var sideBySidePrinter=new SideBySidePrinter(config);return sideBySidePrinter.generateSideBySideJsonHtml(diffFiles)},module.exports.HtmlPrinter=new HtmlPrinter}()},function(module,exports,__webpack_require__){!function(){function LineByLinePrinter(config){this.config=config}var diffParser=__webpack_require__(1).DiffParser,printerUtils=__webpack_require__(4).PrinterUtils,utils=__webpack_require__(2).Utils,Rematch=__webpack_require__(20).Rematch,nunjucksUtils=__webpack_require__(23).NunjucksUtils,baseTemplatesPath="line-by-line";LineByLinePrinter.prototype.makeFileDiffHtml=function(file,diffs){return nunjucksUtils.render(baseTemplatesPath,"file-diff.html",{file:file,diffs:diffs})},LineByLinePrinter.prototype.makeLineByLineHtmlWrapper=function(content){return nunjucksUtils.render(baseTemplatesPath,"wrapper.html",{content:content})},LineByLinePrinter.prototype.generateLineByLineJsonHtml=function(diffFiles){var that=this,htmlDiffs=diffFiles.map(function(file){var diffs;return diffs=file.blocks.length?that._generateFileHtml(file):that._generateEmptyDiff(),that.makeFileDiffHtml(file,diffs)});return this.makeLineByLineHtmlWrapper(htmlDiffs.join("\n"))};var matcher=Rematch.rematch(function(a,b){var amod=a.content.substr(1),bmod=b.content.substr(1);return Rematch.distance(amod,bmod)});LineByLinePrinter.prototype.makeColumnLineNumberHtml=function(block){return nunjucksUtils.render(baseTemplatesPath,"column-line-number.html",{block:block})},LineByLinePrinter.prototype._generateFileHtml=function(file){var that=this;return file.blocks.map(function(block){function processChangeBlock(){var matches,insertType,deleteType,doMatching="lines"===that.config.matching||"words"===that.config.matching;doMatching?(matches=matcher(oldLines,newLines),insertType=diffParser.LINE_TYPE.INSERT_CHANGES,deleteType=diffParser.LINE_TYPE.DELETE_CHANGES):(matches=[[oldLines,newLines]],insertType=diffParser.LINE_TYPE.INSERTS,deleteType=diffParser.LINE_TYPE.DELETES),matches.forEach(function(match){oldLines=match[0],newLines=match[1];for(var oldLine,newLine,processedOldLines=[],processedNewLines=[],common=Math.min(oldLines.length,newLines.length),j=0;common>j;j++){oldLine=oldLines[j],newLine=newLines[j],that.config.isCombined=file.isCombined;var diff=printerUtils.diffHighlight(oldLine.content,newLine.content,that.config);processedOldLines+=that.makeLineHtml(deleteType,oldLine.oldNumber,oldLine.newNumber,diff.first.line,diff.first.prefix),processedNewLines+=that.makeLineHtml(insertType,newLine.oldNumber,newLine.newNumber,diff.second.line,diff.second.prefix)}lines+=processedOldLines+processedNewLines,lines+=that._processLines(oldLines.slice(common),newLines.slice(common))}),oldLines=[],newLines=[]}for(var lines=that.makeColumnLineNumberHtml(block),oldLines=[],newLines=[],i=0;i<block.lines.length;i++){var line=block.lines[i],escapedLine=utils.escape(line.content);line.type!==diffParser.LINE_TYPE.INSERTS&&(newLines.length>0||line.type!==diffParser.LINE_TYPE.DELETES&&oldLines.length>0)&&processChangeBlock(),line.type===diffParser.LINE_TYPE.CONTEXT?lines+=that.makeLineHtml(line.type,line.oldNumber,line.newNumber,escapedLine):line.type!==diffParser.LINE_TYPE.INSERTS||oldLines.length?line.type===diffParser.LINE_TYPE.DELETES?oldLines.push(line):line.type===diffParser.LINE_TYPE.INSERTS&&Boolean(oldLines.length)?newLines.push(line):(console.error("Unknown state in html line-by-line generator"),processChangeBlock()):lines+=that.makeLineHtml(line.type,line.oldNumber,line.newNumber,escapedLine)}return processChangeBlock(),lines}).join("\n")},LineByLinePrinter.prototype._processLines=function(oldLines,newLines){for(var lines="",i=0;i<oldLines.length;i++){var oldLine=oldLines[i],oldEscapedLine=utils.escape(oldLine.content);lines+=this.makeLineHtml(oldLine.type,oldLine.oldNumber,oldLine.newNumber,oldEscapedLine)}for(var j=0;j<newLines.length;j++){var newLine=newLines[j],newEscapedLine=utils.escape(newLine.content);lines+=this.makeLineHtml(newLine.type,newLine.oldNumber,newLine.newNumber,newEscapedLine)}return lines},LineByLinePrinter.prototype.makeLineHtml=function(type,oldNumber,newNumber,content,prefix){return nunjucksUtils.render(baseTemplatesPath,"line.html",{type:type,oldNumber:oldNumber,newNumber:newNumber,prefix:prefix,content:content})},LineByLinePrinter.prototype._generateEmptyDiff=function(){return nunjucksUtils.render(baseTemplatesPath,"empty-diff.html",{})},module.exports.LineByLinePrinter=LineByLinePrinter}()},function(module,exports,__webpack_require__){(function(__dirname){!function(){function NunjucksUtils(){}var path=__webpack_require__(24),nunjucks=__webpack_require__(26),templatesPath=path.resolve(__dirname,"templates"),diffParser=__webpack_require__(1).DiffParser,printerUtils=__webpack_require__(4).PrinterUtils,utils=__webpack_require__(2).Utils,nunjucksEnv=nunjucks.configure(templatesPath,{autoescape:!1}).addGlobal("printerUtils",printerUtils).addGlobal("utils",utils).addGlobal("diffParser",diffParser);NunjucksUtils.prototype.render=function(namespace,view,params){var viewPath=path.join(namespace,view);return nunjucksEnv.render(viewPath,params)},module.exports.NunjucksUtils=new NunjucksUtils}()}).call(exports,"/")},function(module,exports,__webpack_require__){(function(process){function normalizeArray(parts,allowAboveRoot){for(var up=0,i=parts.length-1;i>=0;i--){var last=parts[i];"."===last?parts.splice(i,1):".."===last?(parts.splice(i,1),up++):up&&(parts.splice(i,1),up--)}if(allowAboveRoot)for(;up--;up)parts.unshift("..");return parts}function filter(xs,f){if(xs.filter)return xs.filter(f);for(var res=[],i=0;i<xs.length;i++)f(xs[i],i,xs)&&res.push(xs[i]);return res}var splitPathRe=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/,splitPath=function(filename){return splitPathRe.exec(filename).slice(1)};exports.resolve=function(){for(var resolvedPath="",resolvedAbsolute=!1,i=arguments.length-1;i>=-1&&!resolvedAbsolute;i--){var path=i>=0?arguments[i]:process.cwd();if("string"!=typeof path)throw new TypeError("Arguments to path.resolve must be strings");path&&(resolvedPath=path+"/"+resolvedPath,resolvedAbsolute="/"===path.charAt(0))}return resolvedPath=normalizeArray(filter(resolvedPath.split("/"),function(p){return!!p}),!resolvedAbsolute).join("/"),(resolvedAbsolute?"/":"")+resolvedPath||"."},exports.normalize=function(path){var isAbsolute=exports.isAbsolute(path),trailingSlash="/"===substr(path,-1);return path=normalizeArray(filter(path.split("/"),function(p){return!!p}),!isAbsolute).join("/"),path||isAbsolute||(path="."),path&&trailingSlash&&(path+="/"),(isAbsolute?"/":"")+path},exports.isAbsolute=function(path){return"/"===path.charAt(0)},exports.join=function(){var paths=Array.prototype.slice.call(arguments,0);return exports.normalize(filter(paths,function(p){if("string"!=typeof p)throw new TypeError("Arguments to path.join must be strings");return p}).join("/"))},exports.relative=function(from,to){function trim(arr){for(var start=0;start<arr.length&&""===arr[start];start++);for(var end=arr.length-1;end>=0&&""===arr[end];end--);return start>end?[]:arr.slice(start,end-start+1)}from=exports.resolve(from).substr(1),to=exports.resolve(to).substr(1);for(var fromParts=trim(from.split("/")),toParts=trim(to.split("/")),length=Math.min(fromParts.length,toParts.length),samePartsLength=length,i=0;length>i;i++)if(fromParts[i]!==toParts[i]){samePartsLength=i;break}for(var outputParts=[],i=samePartsLength;i<fromParts.length;i++)outputParts.push("..");return outputParts=outputParts.concat(toParts.slice(samePartsLength)),outputParts.join("/")},exports.sep="/",exports.delimiter=":",exports.dirname=function(path){var result=splitPath(path),root=result[0],dir=result[1];return root||dir?(dir&&(dir=dir.substr(0,dir.length-1)),root+dir):"."},exports.basename=function(path,ext){var f=splitPath(path)[2];return ext&&f.substr(-1*ext.length)===ext&&(f=f.substr(0,f.length-ext.length)),f},exports.extname=function(path){return splitPath(path)[3]};var substr="b"==="ab".substr(-1)?function(str,start,len){return str.substr(start,len)}:function(str,start,len){return 0>start&&(start=str.length+start),str.substr(start,len)}}).call(exports,__webpack_require__(25))},function(module){function cleanUpNextTick(){draining=!1,currentQueue.length?queue=currentQueue.concat(queue):queueIndex=-1,queue.length&&drainQueue()}function drainQueue(){if(!draining){var timeout=setTimeout(cleanUpNextTick);draining=!0;for(var len=queue.length;len;){for(currentQueue=queue,queue=[];++queueIndex<len;)currentQueue&&currentQueue[queueIndex].run();queueIndex=-1,len=queue.length}currentQueue=null,draining=!1,clearTimeout(timeout)}}function Item(fun,array){this.fun=fun,this.array=array}function noop(){}var currentQueue,process=module.exports={},queue=[],draining=!1,queueIndex=-1;process.nextTick=function(fun){var args=new Array(arguments.length-1);if(arguments.length>1)for(var i=1;i<arguments.length;i++)args[i-1]=arguments[i];queue.push(new Item(fun,args)),1!==queue.length||draining||setTimeout(drainQueue,0)},Item.prototype.run=function(){this.fun.apply(null,this.array)},process.title="browser",process.browser=!0,process.env={},process.argv=[],process.version="",process.versions={},process.on=noop,process.addListener=noop,process.once=noop,process.off=noop,process.removeListener=noop,process.removeAllListeners=noop,process.emit=noop,process.binding=function(){throw new Error("process.binding is not supported")},process.cwd=function(){return"/"},process.chdir=function(){throw new Error("process.chdir is not supported")},process.umask=function(){return 0}},function(module,exports,__webpack_require__){"use strict";var lib=__webpack_require__(27),env=__webpack_require__(28),Loader=__webpack_require__(37),loaders=__webpack_require__(32),precompile=__webpack_require__(32);module.exports={},module.exports.Environment=env.Environment,module.exports.Template=env.Template,module.exports.Loader=Loader,module.exports.FileSystemLoader=loaders.FileSystemLoader,module.exports.PrecompiledLoader=loaders.PrecompiledLoader,module.exports.WebLoader=loaders.WebLoader,module.exports.compiler=__webpack_require__(32),module.exports.parser=__webpack_require__(32),module.exports.lexer=__webpack_require__(32),module.exports.runtime=__webpack_require__(34),module.exports.lib=lib,module.exports.nodes=__webpack_require__(32),module.exports.installJinjaCompat=__webpack_require__(38);var e;module.exports.configure=function(templatesPath,opts){opts=opts||{},lib.isObject(templatesPath)&&(opts=templatesPath,templatesPath=null);var TemplateLoader;return loaders.FileSystemLoader?TemplateLoader=new loaders.FileSystemLoader(templatesPath,{watch:opts.watch,noCache:opts.noCache}):loaders.WebLoader&&(TemplateLoader=new loaders.WebLoader(templatesPath,{useCache:opts.web&&opts.web.useCache,async:opts.web&&opts.web.async})),e=new env.Environment(TemplateLoader,opts),opts&&opts.express&&e.express(opts.express),e},module.exports.compile=function(src,env,path,eagerCompile){return e||module.exports.configure(),new module.exports.Template(src,env,path,eagerCompile)},module.exports.render=function(name,ctx,cb){return e||module.exports.configure(),e.render(name,ctx,cb)},module.exports.renderString=function(src,ctx,cb){return e||module.exports.configure(),e.renderString(src,ctx,cb)},precompile&&(module.exports.precompile=precompile.precompile,module.exports.precompileString=precompile.precompileString)},function(module,exports){"use strict";var ArrayProto=Array.prototype,ObjProto=Object.prototype,escapeMap={"&":"&amp;",'"':"&quot;","'":"&#39;","<":"&lt;",">":"&gt;"},escapeRegex=/[&"'<>]/g,lookupEscape=function(ch){return escapeMap[ch]},exports=module.exports={};exports.prettifyError=function(path,withInternals,err){if(err.Update||(err=new exports.TemplateError(err)),err.Update(path),!withInternals){var old=err;err=new Error(old.message),err.name=old.name}return err},exports.TemplateError=function(message,lineno,colno){var err=this;if(message instanceof Error){err=message,message=message.name+": "+message.message;try{err.name=""}catch(e){err=this}}else Error.captureStackTrace&&Error.captureStackTrace(err);return err.name="Template render error",err.message=message,err.lineno=lineno,err.colno=colno,err.firstUpdate=!0,err.Update=function(path){var message="("+(path||"unknown path")+")";return this.firstUpdate&&(this.lineno&&this.colno?message+=" [Line "+this.lineno+", Column "+this.colno+"]":this.lineno&&(message+=" [Line "+this.lineno+"]")),message+="\n ",this.firstUpdate&&(message+=" "),this.message=message+(this.message||""),this.firstUpdate=!1,this},err},exports.TemplateError.prototype=Error.prototype,exports.escape=function(val){return val.replace(escapeRegex,lookupEscape)},exports.isFunction=function(obj){return"[object Function]"===ObjProto.toString.call(obj)},exports.isArray=Array.isArray||function(obj){return"[object Array]"===ObjProto.toString.call(obj)},exports.isString=function(obj){return"[object String]"===ObjProto.toString.call(obj)},exports.isObject=function(obj){return"[object Object]"===ObjProto.toString.call(obj)},exports.groupBy=function(obj,val){for(var result={},iterator=exports.isFunction(val)?val:function(obj){return obj[val]},i=0;i<obj.length;i++){var value=obj[i],key=iterator(value,i);(result[key]||(result[key]=[])).push(value)}return result},exports.toArray=function(obj){return Array.prototype.slice.call(obj)},exports.without=function(array){var result=[];if(!array)return result;for(var index=-1,length=array.length,contains=exports.toArray(arguments).slice(1);++index<length;)-1===exports.indexOf(contains,array[index])&&result.push(array[index]);return result},exports.extend=function(obj,obj2){for(var k in obj2)obj[k]=obj2[k];return obj},exports.repeat=function(char_,n){for(var str="",i=0;n>i;i++)str+=char_;return str},exports.each=function(obj,func,context){if(null!=obj)if(ArrayProto.each&&obj.each===ArrayProto.each)obj.forEach(func,context);else if(obj.length===+obj.length)for(var i=0,l=obj.length;l>i;i++)func.call(context,obj[i],i,obj)},exports.map=function(obj,func){var results=[];if(null==obj)return results;if(ArrayProto.map&&obj.map===ArrayProto.map)return obj.map(func);for(var i=0;i<obj.length;i++)results[results.length]=func(obj[i],i);return obj.length===+obj.length&&(results.length=obj.length),results},exports.asyncIter=function(arr,iter,cb){function next(){i++,i<arr.length?iter(arr[i],i,next,cb):cb()}var i=-1;next()},exports.asyncFor=function(obj,iter,cb){function next(){i++;var k=keys[i];len>i?iter(k,obj[k],i,len,next):cb()}var keys=exports.keys(obj),len=keys.length,i=-1;next()},exports.indexOf=Array.prototype.indexOf?function(arr,searchElement,fromIndex){return Array.prototype.indexOf.call(arr,searchElement,fromIndex)}:function(arr,searchElement,fromIndex){var length=this.length>>>0;for(fromIndex=+fromIndex||0,Math.abs(fromIndex)===1/0&&(fromIndex=0),0>fromIndex&&(fromIndex+=length,0>fromIndex&&(fromIndex=0));length>fromIndex;fromIndex++)if(arr[fromIndex]===searchElement)return fromIndex;return-1},Array.prototype.map||(Array.prototype.map=function(){throw new Error("map is unimplemented for this js engine")}),exports.keys=function(obj){if(Object.prototype.keys)return obj.keys();var keys=[];for(var k in obj)obj.hasOwnProperty(k)&&keys.push(k);return keys},exports.inOperator=function(key,arrOrObj){if(exports.isArray(arrOrObj))return-1!==exports.indexOf(arrOrObj,key);if(exports.isObject(arrOrObj))return key in arrOrObj;throw new Error('Cannot use "in" operator to search for "'+key+'" in unexpected types.')}},function(module,exports,__webpack_require__){"use strict";function callbackAsap(cb,err,res){asap(function(){cb(err,res)})}var Template,path=__webpack_require__(24),asap=__webpack_require__(29),lib=__webpack_require__(27),Obj=__webpack_require__(31),compiler=__webpack_require__(32),builtin_filters=__webpack_require__(33),builtin_loaders=__webpack_require__(32),runtime=__webpack_require__(34),globals=__webpack_require__(35),Frame=runtime.Frame;builtin_loaders.PrecompiledLoader=__webpack_require__(36);var Environment=Obj.extend({init:function(loaders,opts){opts=this.opts=opts||{},this.opts.dev=!!opts.dev,this.opts.autoescape=null!=opts.autoescape?opts.autoescape:!0,this.opts.throwOnUndefined=!!opts.throwOnUndefined,this.opts.trimBlocks=!!opts.trimBlocks,this.opts.lstripBlocks=!!opts.lstripBlocks,this.loaders=[],loaders?this.loaders=lib.isArray(loaders)?loaders:[loaders]:builtin_loaders.FileSystemLoader?this.loaders=[new builtin_loaders.FileSystemLoader("views")]:builtin_loaders.WebLoader&&(this.loaders=[new builtin_loaders.WebLoader("/views")]),window.nunjucksPrecompiled&&this.loaders.unshift(new builtin_loaders.PrecompiledLoader(window.nunjucksPrecompiled)),this.initCache(),this.globals=globals(),this.filters={},this.asyncFilters=[],this.extensions={},this.extensionsList=[];for(var name in builtin_filters)this.addFilter(name,builtin_filters[name])},initCache:function(){lib.each(this.loaders,function(loader){loader.cache={},"function"==typeof loader.on&&loader.on("update",function(template){loader.cache[template]=null})})},addExtension:function(name,extension){return extension._name=name,this.extensions[name]=extension,this.extensionsList.push(extension),this},removeExtension:function(name){var extension=this.getExtension(name);extension&&(this.extensionsList=lib.without(this.extensionsList,extension),delete this.extensions[name])},getExtension:function(name){return this.extensions[name]},hasExtension:function(name){return!!this.extensions[name]},addGlobal:function(name,value){return this.globals[name]=value,this},getGlobal:function(name){if("undefined"==typeof this.globals[name])throw new Error("global not found: "+name);return this.globals[name]},addFilter:function(name,func,async){var wrapped=func;return async&&this.asyncFilters.push(name),this.filters[name]=wrapped,this},getFilter:function(name){if(!this.filters[name])throw new Error("filter not found: "+name);return this.filters[name]},resolveTemplate:function(loader,parentName,filename){var isRelative=loader.isRelative&&parentName?loader.isRelative(filename):!1;return isRelative&&loader.resolve?loader.resolve(parentName,filename):filename},getTemplate:function(name,eagerCompile,parentName,ignoreMissing,cb){var that=this,tmpl=null;if(name&&name.raw&&(name=name.raw),lib.isFunction(parentName)&&(cb=parentName,parentName=null,eagerCompile=eagerCompile||!1),lib.isFunction(eagerCompile)&&(cb=eagerCompile,eagerCompile=!1),name instanceof Template)tmpl=name;else{if("string"!=typeof name)throw new Error("template names must be a string: "+name);for(var i=0;i<this.loaders.length;i++){var _name=this.resolveTemplate(this.loaders[i],parentName,name);if(tmpl=this.loaders[i].cache[_name])break}}if(!tmpl){var syncResult,_this=this,createTemplate=function(err,info){if(info||err||ignoreMissing||(err=new Error("template not found: "+name)),err){if(!cb)throw err;cb(err)}else{var tmpl;info?(tmpl=new Template(info.src,_this,info.path,eagerCompile),info.noCache||(info.loader.cache[name]=tmpl)):tmpl=new Template("",_this,"",eagerCompile),cb?cb(null,tmpl):syncResult=tmpl}};return lib.asyncIter(this.loaders,function(loader,i,next,done){function handle(err,src){err?done(err):src?(src.loader=loader,done(null,src)):next()}name=that.resolveTemplate(loader,parentName,name),loader.async?loader.getSource(name,handle):handle(null,loader.getSource(name))},createTemplate),syncResult}return eagerCompile&&tmpl.compile(),cb?void cb(null,tmpl):tmpl},express:function(app){function NunjucksView(name,opts){if(this.name=name,this.path=name,this.defaultEngine=opts.defaultEngine,this.ext=path.extname(name),!this.ext&&!this.defaultEngine)throw new Error("No default engine was specified and no extension was provided.");this.ext||(this.name+=this.ext=("."!==this.defaultEngine[0]?".":"")+this.defaultEngine)}var env=this;return NunjucksView.prototype.render=function(opts,cb){env.render(this.name,opts,cb)},app.set("view",NunjucksView),this},render:function(name,ctx,cb){lib.isFunction(ctx)&&(cb=ctx,ctx=null);var syncResult=null;return this.getTemplate(name,function(err,tmpl){if(err&&cb)callbackAsap(cb,err);else{if(err)throw err;syncResult=tmpl.render(ctx,cb)}}),syncResult},renderString:function(src,ctx,opts,cb){lib.isFunction(opts)&&(cb=opts,opts={}),opts=opts||{};var tmpl=new Template(src,this,opts.path);return tmpl.render(ctx,cb)}}),Context=Obj.extend({init:function(ctx,blocks,env){this.env=env||new Environment,this.ctx={};for(var k in ctx)ctx.hasOwnProperty(k)&&(this.ctx[k]=ctx[k]);this.blocks={},this.exported=[];for(var name in blocks)this.addBlock(name,blocks[name])},lookup:function(name){return name in this.env.globals&&!(name in this.ctx)?this.env.globals[name]:this.ctx[name]},setVariable:function(name,val){this.ctx[name]=val},getVariables:function(){return this.ctx},addBlock:function(name,block){return this.blocks[name]=this.blocks[name]||[],this.blocks[name].push(block),this},getBlock:function(name){if(!this.blocks[name])throw new Error('unknown block "'+name+'"');return this.blocks[name][0]},getSuper:function(env,name,block,frame,runtime,cb){var idx=lib.indexOf(this.blocks[name]||[],block),blk=this.blocks[name][idx+1],context=this;if(-1===idx||!blk)throw new Error('no super block available for "'+name+'"');blk(env,context,frame,runtime,cb)},addExport:function(name){this.exported.push(name)},getExported:function(){for(var exported={},i=0;i<this.exported.length;i++){var name=this.exported[i];exported[name]=this.ctx[name]}return exported}});Template=Obj.extend({init:function(src,env,path,eagerCompile){if(this.env=env||new Environment,lib.isObject(src))switch(src.type){case"code":this.tmplProps=src.obj;break;case"string":this.tmplStr=src.obj}else{if(!lib.isString(src))throw new Error("src must be a string or an object describing the source");this.tmplStr=src}if(this.path=path,eagerCompile){var _this=this;try{_this._compile()}catch(err){throw lib.prettifyError(this.path,this.env.opts.dev,err)}}else this.compiled=!1},render:function(ctx,parentFrame,cb){"function"==typeof ctx?(cb=ctx,ctx={}):"function"==typeof parentFrame&&(cb=parentFrame,parentFrame=null);var forceAsync=!0;parentFrame&&(forceAsync=!1);var _this=this;try{_this.compile()}catch(_err){var err=lib.prettifyError(this.path,this.env.opts.dev,_err);if(cb)return callbackAsap(cb,err);throw err}var context=new Context(ctx||{},_this.blocks,_this.env),frame=parentFrame?parentFrame.push(!0):new Frame;frame.topLevel=!0;var syncResult=null;return _this.rootRenderFunc(_this.env,context,frame||new Frame,runtime,function(err,res){if(err&&(err=lib.prettifyError(_this.path,_this.env.opts.dev,err)),cb)forceAsync?callbackAsap(cb,err,res):cb(err,res);else{if(err)throw err;syncResult=res}}),syncResult},getExported:function(ctx,parentFrame,cb){"function"==typeof ctx&&(cb=ctx,ctx={}),"function"==typeof parentFrame&&(cb=parentFrame,parentFrame=null);try{this.compile()}catch(e){if(cb)return cb(e);throw e}var frame=parentFrame?parentFrame.push():new Frame;frame.topLevel=!0;var context=new Context(ctx||{},this.blocks,this.env);this.rootRenderFunc(this.env,context,frame,runtime,function(err){err?cb(err,null):cb(null,context.getExported())})},compile:function(){this.compiled||this._compile()},_compile:function(){var props;if(this.tmplProps)props=this.tmplProps;else{var source=compiler.compile(this.tmplStr,this.env.asyncFilters,this.env.extensionsList,this.path,this.env.opts),func=new Function(source);props=func()}this.blocks=this._getBlocks(props),this.rootRenderFunc=props.root,this.compiled=!0},_getBlocks:function(props){var blocks={};for(var k in props)"b_"===k.slice(0,2)&&(blocks[k.slice(2)]=props[k]);return blocks}}),module.exports={Environment:Environment,Template:Template}},function(module,exports,__webpack_require__){"use strict";function throwFirstError(){if(pendingErrors.length)throw pendingErrors.shift()}function asap(task){var rawTask;rawTask=freeTasks.length?freeTasks.pop():new RawTask,rawTask.task=task,rawAsap(rawTask)}function RawTask(){this.task=null}var rawAsap=__webpack_require__(30),freeTasks=[],pendingErrors=[],requestErrorThrow=rawAsap.makeRequestCallFromTimer(throwFirstError);module.exports=asap,RawTask.prototype.call=function(){try{this.task.call()}catch(error){asap.onerror?asap.onerror(error):(pendingErrors.push(error),requestErrorThrow())}finally{this.task=null,freeTasks[freeTasks.length]=this}}},function(module,exports){(function(global){"use strict";function rawAsap(task){queue.length||(requestFlush(),flushing=!0),queue[queue.length]=task}function flush(){for(;index<queue.length;){var currentIndex=index;if(index+=1,queue[currentIndex].call(),index>capacity){for(var scan=0,newLength=queue.length-index;newLength>scan;scan++)queue[scan]=queue[scan+index];queue.length-=index,index=0}}queue.length=0,index=0,flushing=!1}function makeRequestCallFromMutationObserver(callback){var toggle=1,observer=new BrowserMutationObserver(callback),node=document.createTextNode("");return observer.observe(node,{characterData:!0}),function(){toggle=-toggle,node.data=toggle}}function makeRequestCallFromTimer(callback){return function(){function handleTimer(){clearTimeout(timeoutHandle),clearInterval(intervalHandle),callback()}var timeoutHandle=setTimeout(handleTimer,0),intervalHandle=setInterval(handleTimer,50)}}module.exports=rawAsap;var requestFlush,queue=[],flushing=!1,index=0,capacity=1024,BrowserMutationObserver=global.MutationObserver||global.WebKitMutationObserver;requestFlush="function"==typeof BrowserMutationObserver?makeRequestCallFromMutationObserver(flush):makeRequestCallFromTimer(flush),rawAsap.requestFlush=requestFlush,rawAsap.makeRequestCallFromTimer=makeRequestCallFromTimer}).call(exports,function(){return this}())},function(module){"use strict";function extend(cls,name,props){var F=function(){};F.prototype=cls.prototype;var prototype=new F,fnTest=/xyz/.test(function(){xyz})?/\bparent\b/:/.*/;props=props||{};for(var k in props){var src=props[k],parent=prototype[k];prototype[k]="function"==typeof parent&&"function"==typeof src&&fnTest.test(src)?function(src,parent){return function(){var tmp=this.parent;this.parent=parent;var res=src.apply(this,arguments);return this.parent=tmp,res}}(src,parent):src}prototype.typename=name;var new_cls=function(){prototype.init&&prototype.init.apply(this,arguments)};return new_cls.prototype=prototype,new_cls.prototype.constructor=new_cls,new_cls.extend=function(name,props){return"object"==typeof name&&(props=name,name="anonymous"),extend(new_cls,name,props)},new_cls}module.exports=extend(Object,"Object",{})},function(){},function(module,exports,__webpack_require__){"use strict";function normalize(value,defaultValue){return null===value||void 0===value||value===!1?defaultValue:value}var lib=__webpack_require__(27),r=__webpack_require__(34),filters={abs:function(n){return Math.abs(n)},batch:function(arr,linecount,fill_with){var i,res=[],tmp=[];for(i=0;i<arr.length;i++)i%linecount===0&&tmp.length&&(res.push(tmp),tmp=[]),tmp.push(arr[i]);if(tmp.length){if(fill_with)for(i=tmp.length;linecount>i;i++)tmp.push(fill_with);res.push(tmp)}return res},capitalize:function(str){str=normalize(str,"");var ret=str.toLowerCase();return r.copySafeness(str,ret.charAt(0).toUpperCase()+ret.slice(1))},center:function(str,width){if(str=normalize(str,""),width=width||80,str.length>=width)return str;var spaces=width-str.length,pre=lib.repeat(" ",spaces/2-spaces%2),post=lib.repeat(" ",spaces/2);return r.copySafeness(str,pre+str+post)},"default":function(val,def,bool){return bool?val?val:def:void 0!==val?val:def},dictsort:function(val,case_sensitive,by){if(!lib.isObject(val))throw new lib.TemplateError("dictsort filter: val must be an object");var array=[];for(var k in val)array.push([k,val[k]]);var si;if(void 0===by||"key"===by)si=0;else{if("value"!==by)throw new lib.TemplateError("dictsort filter: You can only sort by either key or value");si=1}return array.sort(function(t1,t2){var a=t1[si],b=t2[si];return case_sensitive||(lib.isString(a)&&(a=a.toUpperCase()),lib.isString(b)&&(b=b.toUpperCase())),a>b?1:a===b?0:-1}),array},dump:function(obj){return JSON.stringify(obj)},
escape:function(str){return"string"==typeof str?r.markSafe(lib.escape(str)):str},safe:function(str){return r.markSafe(str)},first:function(arr){return arr[0]},groupby:function(arr,attr){return lib.groupBy(arr,attr)},indent:function(str,width,indentfirst){if(str=normalize(str,""),""===str)return"";width=width||4;for(var res="",lines=str.split("\n"),sp=lib.repeat(" ",width),i=0;i<lines.length;i++)res+=0!==i||indentfirst?sp+lines[i]+"\n":lines[i]+"\n";return r.copySafeness(str,res)},join:function(arr,del,attr){return del=del||"",attr&&(arr=lib.map(arr,function(v){return v[attr]})),arr.join(del)},last:function(arr){return arr[arr.length-1]},length:function(val){var value=normalize(val,"");return void 0!==value?value.length:0},list:function(val){if(lib.isString(val))return val.split("");if(lib.isObject(val)){var keys=[];if(Object.keys)keys=Object.keys(val);else for(var k in val)keys.push(k);return lib.map(keys,function(k){return{key:k,value:val[k]}})}if(lib.isArray(val))return val;throw new lib.TemplateError("list filter: type not iterable")},lower:function(str){return str=normalize(str,""),str.toLowerCase()},random:function(arr){return arr[Math.floor(Math.random()*arr.length)]},rejectattr:function(arr,attr){return arr.filter(function(item){return!item[attr]})},selectattr:function(arr,attr){return arr.filter(function(item){return!!item[attr]})},replace:function(str,old,new_,maxCount){var originalStr=str;if(old instanceof RegExp)return str.replace(old,new_);"undefined"==typeof maxCount&&(maxCount=-1);var res="";if("number"==typeof old)old+="";else if("string"!=typeof old)return str;if("number"==typeof str&&(str+=""),"string"!=typeof str&&!(str instanceof r.SafeString))return str;if(""===old)return res=new_+str.split("").join(new_)+new_,r.copySafeness(str,res);var nextIndex=str.indexOf(old);if(0===maxCount||-1===nextIndex)return str;for(var pos=0,count=0;nextIndex>-1&&(-1===maxCount||maxCount>count);)res+=str.substring(pos,nextIndex)+new_,pos=nextIndex+old.length,count++,nextIndex=str.indexOf(old,pos);return pos<str.length&&(res+=str.substring(pos)),r.copySafeness(originalStr,res)},reverse:function(val){var arr;return arr=lib.isString(val)?filters.list(val):lib.map(val,function(v){return v}),arr.reverse(),lib.isString(val)?r.copySafeness(val,arr.join("")):arr},round:function(val,precision,method){precision=precision||0;var rounder,factor=Math.pow(10,precision);return rounder="ceil"===method?Math.ceil:"floor"===method?Math.floor:Math.round,rounder(val*factor)/factor},slice:function(arr,slices,fillWith){for(var sliceLength=Math.floor(arr.length/slices),extra=arr.length%slices,offset=0,res=[],i=0;slices>i;i++){var start=offset+i*sliceLength;extra>i&&offset++;var end=offset+(i+1)*sliceLength,slice=arr.slice(start,end);fillWith&&i>=extra&&slice.push(fillWith),res.push(slice)}return res},sum:function(arr,attr,start){var sum=0;"number"==typeof start&&(sum+=start),attr&&(arr=lib.map(arr,function(v){return v[attr]}));for(var i=0;i<arr.length;i++)sum+=arr[i];return sum},sort:r.makeMacro(["value","reverse","case_sensitive","attribute"],[],function(arr,reverse,caseSens,attr){return arr=lib.map(arr,function(v){return v}),arr.sort(function(a,b){var x,y;return attr?(x=a[attr],y=b[attr]):(x=a,y=b),!caseSens&&lib.isString(x)&&lib.isString(y)&&(x=x.toLowerCase(),y=y.toLowerCase()),y>x?reverse?1:-1:x>y?reverse?-1:1:0}),arr}),string:function(obj){return r.copySafeness(obj,obj)},striptags:function(input,preserve_linebreaks){input=normalize(input,""),preserve_linebreaks=preserve_linebreaks||!1;var tags=/<\/?([a-z][a-z0-9]*)\b[^>]*>|<!--[\s\S]*?-->/gi,trimmedInput=filters.trim(input.replace(tags,"")),res="";return res=preserve_linebreaks?trimmedInput.replace(/^ +| +$/gm,"").replace(/ +/g," ").replace(/(\r\n)/g,"\n").replace(/\n\n\n+/g,"\n\n"):trimmedInput.replace(/\s+/gi," "),r.copySafeness(input,res)},title:function(str){str=normalize(str,"");for(var words=str.split(" "),i=0;i<words.length;i++)words[i]=filters.capitalize(words[i]);return r.copySafeness(str,words.join(" "))},trim:function(str){return r.copySafeness(str,str.replace(/^\s*|\s*$/g,""))},truncate:function(input,length,killwords,end){var orig=input;if(input=normalize(input,""),length=length||255,input.length<=length)return input;if(killwords)input=input.substring(0,length);else{var idx=input.lastIndexOf(" ",length);-1===idx&&(idx=length),input=input.substring(0,idx)}return input+=void 0!==end&&null!==end?end:"...",r.copySafeness(orig,input)},upper:function(str){return str=normalize(str,""),str.toUpperCase()},urlencode:function(obj){var enc=encodeURIComponent;if(lib.isString(obj))return enc(obj);var parts;if(lib.isArray(obj))parts=obj.map(function(item){return enc(item[0])+"="+enc(item[1])});else{parts=[];for(var k in obj)obj.hasOwnProperty(k)&&parts.push(enc(k)+"="+enc(obj[k]))}return parts.join("&")},urlize:function(str,length,nofollow){isNaN(length)&&(length=1/0);var noFollowAttr=nofollow===!0?' rel="nofollow"':"",puncRE=/^(?:\(|<|&lt;)?(.*?)(?:\.|,|\)|\n|&gt;)?$/,emailRE=/^[\w.!#$%&'*+\-\/=?\^`{|}~]+@[a-z\d\-]+(\.[a-z\d\-]+)+$/i,httpHttpsRE=/^https?:\/\/.*$/,wwwRE=/^www\./,tldRE=/\.(?:org|net|com)(?:\:|\/|$)/,words=str.split(/(\s+)/).filter(function(word){return word&&word.length}).map(function(word){var matches=word.match(puncRE),possibleUrl=matches&&matches[1]||word;return httpHttpsRE.test(possibleUrl)?'<a href="'+possibleUrl+'"'+noFollowAttr+">"+possibleUrl.substr(0,length)+"</a>":wwwRE.test(possibleUrl)?'<a href="http://'+possibleUrl+'"'+noFollowAttr+">"+possibleUrl.substr(0,length)+"</a>":emailRE.test(possibleUrl)?'<a href="mailto:'+possibleUrl+'">'+possibleUrl+"</a>":tldRE.test(possibleUrl)?'<a href="http://'+possibleUrl+'"'+noFollowAttr+">"+possibleUrl.substr(0,length)+"</a>":word});return words.join("")},wordcount:function(str){str=normalize(str,"");var words=str?str.match(/\w+/g):null;return words?words.length:null},"float":function(val,def){var res=parseFloat(val);return isNaN(res)?def:res},"int":function(val,def){var res=parseInt(val,10);return isNaN(res)?def:res}};filters.d=filters["default"],filters.e=filters.escape,module.exports=filters},function(module,exports,__webpack_require__){"use strict";function makeMacro(argNames,kwargNames,func){return function(){var args,i,argCount=numArgs(arguments),kwargs=getKeywordArgs(arguments);if(argCount>argNames.length){args=Array.prototype.slice.call(arguments,0,argNames.length);var vals=Array.prototype.slice.call(arguments,args.length,argCount);for(i=0;i<vals.length;i++)i<kwargNames.length&&(kwargs[kwargNames[i]]=vals[i]);args.push(kwargs)}else if(argCount<argNames.length){for(args=Array.prototype.slice.call(arguments,0,argCount),i=argCount;i<argNames.length;i++){var arg=argNames[i];args.push(kwargs[arg]),delete kwargs[arg]}args.push(kwargs)}else args=arguments;return func.apply(this,args)}}function makeKeywordArgs(obj){return obj.__keywords=!0,obj}function getKeywordArgs(args){var len=args.length;if(len){var lastArg=args[len-1];if(lastArg&&lastArg.hasOwnProperty("__keywords"))return lastArg}return{}}function numArgs(args){var len=args.length;if(0===len)return 0;var lastArg=args[len-1];return lastArg&&lastArg.hasOwnProperty("__keywords")?len-1:len}function SafeString(val){return"string"!=typeof val?val:(this.val=val,void(this.length=val.length))}function copySafeness(dest,target){return dest instanceof SafeString?new SafeString(target):target.toString()}function markSafe(val){var type=typeof val;return"string"===type?new SafeString(val):"function"!==type?val:function(){var ret=val.apply(this,arguments);return"string"==typeof ret?new SafeString(ret):ret}}function suppressValue(val,autoescape){return val=void 0!==val&&null!==val?val:"",autoescape&&"string"==typeof val&&(val=lib.escape(val)),val}function ensureDefined(val,lineno,colno){if(null===val||void 0===val)throw new lib.TemplateError("attempted to output null or undefined value",lineno+1,colno+1);return val}function memberLookup(obj,val){return obj=obj||{},"function"==typeof obj[val]?function(){return obj[val].apply(obj,arguments)}:obj[val]}function callWrap(obj,name,context,args){if(!obj)throw new Error("Unable to call `"+name+"`, which is undefined or falsey");if("function"!=typeof obj)throw new Error("Unable to call `"+name+"`, which is not a function");return obj.apply(context,args)}function contextOrFrameLookup(context,frame,name){var val=frame.lookup(name);return void 0!==val&&null!==val?val:context.lookup(name)}function handleError(error,lineno,colno){return error.lineno?error:new lib.TemplateError(error,lineno,colno)}function asyncEach(arr,dimen,iter,cb){if(lib.isArray(arr)){var len=arr.length;lib.asyncIter(arr,function(item,i,next){switch(dimen){case 1:iter(item,i,len,next);break;case 2:iter(item[0],item[1],i,len,next);break;case 3:iter(item[0],item[1],item[2],i,len,next);break;default:item.push(i,next),iter.apply(this,item)}},cb)}else lib.asyncFor(arr,function(key,val,i,len,next){iter(key,val,i,len,next)},cb)}function asyncAll(arr,dimen,func,cb){function done(i,output){finished++,outputArr[i]=output,finished===len&&cb(null,outputArr.join(""))}var len,i,outputArr,finished=0;if(lib.isArray(arr))if(len=arr.length,outputArr=new Array(len),0===len)cb(null,"");else for(i=0;i<arr.length;i++){var item=arr[i];switch(dimen){case 1:func(item,i,len,done);break;case 2:func(item[0],item[1],i,len,done);break;case 3:func(item[0],item[1],item[2],i,len,done);break;default:item.push(i,done),func.apply(this,item)}}else{var keys=lib.keys(arr);if(len=keys.length,outputArr=new Array(len),0===len)cb(null,"");else for(i=0;i<keys.length;i++){var k=keys[i];func(k,arr[k],i,len,done)}}}var lib=__webpack_require__(27),Obj=__webpack_require__(31),Frame=Obj.extend({init:function(parent,isolateWrites){this.variables={},this.parent=parent,this.topLevel=!1,this.isolateWrites=isolateWrites},set:function(name,val,resolveUp){var parts=name.split("."),obj=this.variables,frame=this;if(resolveUp&&(frame=this.resolve(parts[0],!0)))return void frame.set(name,val);for(var i=0;i<parts.length-1;i++){var id=parts[i];obj[id]||(obj[id]={}),obj=obj[id]}obj[parts[parts.length-1]]=val},get:function(name){var val=this.variables[name];return void 0!==val&&null!==val?val:null},lookup:function(name){var p=this.parent,val=this.variables[name];return void 0!==val&&null!==val?val:p&&p.lookup(name)},resolve:function(name,forWrite){var p=forWrite&&this.isolateWrites?void 0:this.parent,val=this.variables[name];return void 0!==val&&null!==val?this:p&&p.resolve(name)},push:function(isolateWrites){return new Frame(this,isolateWrites)},pop:function(){return this.parent}});SafeString.prototype=Object.create(String.prototype,{length:{writable:!0,configurable:!0,value:0}}),SafeString.prototype.valueOf=function(){return this.val},SafeString.prototype.toString=function(){return this.val},module.exports={Frame:Frame,makeMacro:makeMacro,makeKeywordArgs:makeKeywordArgs,numArgs:numArgs,suppressValue:suppressValue,ensureDefined:ensureDefined,memberLookup:memberLookup,contextOrFrameLookup:contextOrFrameLookup,callWrap:callWrap,handleError:handleError,isArray:lib.isArray,keys:lib.keys,SafeString:SafeString,copySafeness:copySafeness,markSafe:markSafe,asyncEach:asyncEach,asyncAll:asyncAll,inOperator:lib.inOperator}},function(module){"use strict";function cycler(items){var index=-1;return{current:null,reset:function(){index=-1,this.current=null},next:function(){return index++,index>=items.length&&(index=0),this.current=items[index],this.current}}}function joiner(sep){sep=sep||",";var first=!0;return function(){var val=first?"":sep;return first=!1,val}}function globals(){return{range:function(start,stop,step){"undefined"==typeof stop?(stop=start,start=0,step=1):step||(step=1);var i,arr=[];if(step>0)for(i=start;stop>i;i+=step)arr.push(i);else for(i=start;i>stop;i+=step)arr.push(i);return arr},cycler:function(){return cycler(Array.prototype.slice.call(arguments))},joiner:function(sep){return joiner(sep)}}}module.exports=globals},function(module,exports,__webpack_require__){"use strict";var Loader=__webpack_require__(37),PrecompiledLoader=Loader.extend({init:function(compiledTemplates){this.precompiled=compiledTemplates||{}},getSource:function(name){return this.precompiled[name]?{src:{type:"code",obj:this.precompiled[name]},path:name}:null}});module.exports=PrecompiledLoader},function(module,exports,__webpack_require__){"use strict";var path=__webpack_require__(24),Obj=__webpack_require__(31),lib=__webpack_require__(27),Loader=Obj.extend({on:function(name,func){this.listeners=this.listeners||{},this.listeners[name]=this.listeners[name]||[],this.listeners[name].push(func)},emit:function(name){var args=Array.prototype.slice.call(arguments,1);this.listeners&&this.listeners[name]&&lib.each(this.listeners[name],function(listener){listener.apply(null,args)})},resolve:function(from,to){return path.resolve(path.dirname(from),to)},isRelative:function(filename){return 0===filename.indexOf("./")||0===filename.indexOf("../")}});module.exports=Loader},function(module){function installCompat(){"use strict";var runtime=this.runtime,lib=this.lib,orig_contextOrFrameLookup=runtime.contextOrFrameLookup;runtime.contextOrFrameLookup=function(context,frame,key){var val=orig_contextOrFrameLookup.apply(this,arguments);if(void 0===val)switch(key){case"True":return!0;case"False":return!1;case"None":return null}return val};var orig_memberLookup=runtime.memberLookup,ARRAY_MEMBERS={pop:function(index){if(void 0===index)return this.pop();if(index>=this.length||0>index)throw new Error("KeyError");return this.splice(index,1)},remove:function(element){for(var i=0;i<this.length;i++)if(this[i]===element)return this.splice(i,1);throw new Error("ValueError")},count:function(element){for(var count=0,i=0;i<this.length;i++)this[i]===element&&count++;return count},index:function(element){var i;if(-1===(i=this.indexOf(element)))throw new Error("ValueError");return i},find:function(element){return this.indexOf(element)},insert:function(index,elem){return this.splice(index,0,elem)}},OBJECT_MEMBERS={items:function(){var ret=[];for(var k in this)ret.push([k,this[k]]);return ret},values:function(){var ret=[];for(var k in this)ret.push(this[k]);return ret},keys:function(){var ret=[];for(var k in this)ret.push(k);return ret},get:function(key,def){var output=this[key];return void 0===output&&(output=def),output},has_key:function(key){return this.hasOwnProperty(key)},pop:function(key,def){var output=this[key];if(void 0===output&&void 0!==def)output=def;else{if(void 0===output)throw new Error("KeyError");delete this[key]}return output},popitem:function(){for(var k in this){var val=this[k];return delete this[k],[k,val]}throw new Error("KeyError")},setdefault:function(key,def){return key in this?this[key]:(void 0===def&&(def=null),this[key]=def)},update:function(kwargs){for(var k in kwargs)this[k]=kwargs[k];return null}};OBJECT_MEMBERS.iteritems=OBJECT_MEMBERS.items,OBJECT_MEMBERS.itervalues=OBJECT_MEMBERS.values,OBJECT_MEMBERS.iterkeys=OBJECT_MEMBERS.keys,runtime.memberLookup=function(obj,val){return obj=obj||{},lib.isArray(obj)&&ARRAY_MEMBERS.hasOwnProperty(val)?function(){return ARRAY_MEMBERS[val].apply(obj,arguments)}:lib.isObject(obj)&&OBJECT_MEMBERS.hasOwnProperty(val)?function(){return OBJECT_MEMBERS[val].apply(obj,arguments)}:orig_memberLookup.apply(this,arguments)}}module.exports=installCompat},function(module,exports,__webpack_require__){!function(){function SideBySidePrinter(config){this.config=config}var diffParser=__webpack_require__(1).DiffParser,printerUtils=__webpack_require__(4).PrinterUtils,utils=__webpack_require__(2).Utils,Rematch=__webpack_require__(20).Rematch,matcher=Rematch.rematch(function(a,b){var amod=a.content.substr(1),bmod=b.content.substr(1);return Rematch.distance(amod,bmod)});SideBySidePrinter.prototype.makeDiffHtml=function(file,diffs){return'<div id="'+printerUtils.getHtmlId(file)+'" class="d2h-file-wrapper" data-lang="'+file.language+'">\n     <div class="d2h-file-header">\n       <span class="d2h-file-stats">\n         <span class="d2h-lines-added">\n           <span>+'+file.addedLines+'</span>\n         </span>\n         <span class="d2h-lines-deleted">\n           <span>-'+file.deletedLines+'</span>\n         </span>\n       </span>\n       <span class="d2h-file-name-wrapper">\n         <span class="d2h-file-name">'+printerUtils.getDiffName(file)+'</span>\n       </span>\n     </div>\n     <div class="d2h-files-diff">\n       <div class="d2h-file-side-diff">\n         <div class="d2h-code-wrapper">\n           <table class="d2h-diff-table">\n             <tbody class="d2h-diff-tbody">\n           '+diffs.left+'             </tbody>\n           </table>\n         </div>\n       </div>\n       <div class="d2h-file-side-diff">\n         <div class="d2h-code-wrapper">\n           <table class="d2h-diff-table">\n             <tbody class="d2h-diff-tbody">\n           '+diffs.right+"             </tbody>\n           </table>\n         </div>\n       </div>\n     </div>\n   </div>\n"},SideBySidePrinter.prototype.generateSideBySideJsonHtml=function(diffFiles){var that=this;return'<div class="d2h-wrapper">\n'+diffFiles.map(function(file){var diffs;return diffs=file.blocks.length?that.generateSideBySideFileHtml(file):that.generateEmptyDiff(),that.makeDiffHtml(file,diffs)}).join("\n")+"</div>\n"},SideBySidePrinter.prototype.makeSideHtml=function(blockHeader){return'<tr>\n  <td class="d2h-code-side-linenumber '+diffParser.LINE_TYPE.INFO+'"></td>\n  <td class="'+diffParser.LINE_TYPE.INFO+'">\n    <div class="d2h-code-side-line '+diffParser.LINE_TYPE.INFO+'">'+blockHeader+"</div>\n  </td>\n</tr>\n"},SideBySidePrinter.prototype.generateSideBySideFileHtml=function(file){var that=this,fileHtml={};return fileHtml.left="",fileHtml.right="",file.blocks.forEach(function(block){function processChangeBlock(){var matches,insertType,deleteType,doMatching="lines"===that.config.matching||"words"===that.config.matching;doMatching?(matches=matcher(oldLines,newLines),insertType=diffParser.LINE_TYPE.INSERT_CHANGES,deleteType=diffParser.LINE_TYPE.DELETE_CHANGES):(matches=[[oldLines,newLines]],insertType=diffParser.LINE_TYPE.INSERTS,deleteType=diffParser.LINE_TYPE.DELETES),matches.forEach(function(match){oldLines=match[0],newLines=match[1];for(var common=Math.min(oldLines.length,newLines.length),max=Math.max(oldLines.length,newLines.length),j=0;common>j;j++){var oldLine=oldLines[j],newLine=newLines[j];that.config.isCombined=file.isCombined;var diff=printerUtils.diffHighlight(oldLine.content,newLine.content,that.config);fileHtml.left+=that.generateSingleLineHtml(deleteType,oldLine.oldNumber,diff.first.line,diff.first.prefix),fileHtml.right+=that.generateSingleLineHtml(insertType,newLine.newNumber,diff.second.line,diff.second.prefix)}if(max>common){var oldSlice=oldLines.slice(common),newSlice=newLines.slice(common),tmpHtml=that.processLines(oldSlice,newSlice);fileHtml.left+=tmpHtml.left,fileHtml.right+=tmpHtml.right}}),oldLines=[],newLines=[]}fileHtml.left+=that.makeSideHtml(utils.escape(block.header)),fileHtml.right+=that.makeSideHtml("");for(var oldLines=[],newLines=[],i=0;i<block.lines.length;i++){var line=block.lines[i],prefix=line.content[0],escapedLine=utils.escape(line.content.substr(1));line.type!==diffParser.LINE_TYPE.INSERTS&&(newLines.length>0||line.type!==diffParser.LINE_TYPE.DELETES&&oldLines.length>0)&&processChangeBlock(),line.type===diffParser.LINE_TYPE.CONTEXT?(fileHtml.left+=that.generateSingleLineHtml(line.type,line.oldNumber,escapedLine,prefix),fileHtml.right+=that.generateSingleLineHtml(line.type,line.newNumber,escapedLine,prefix)):line.type!==diffParser.LINE_TYPE.INSERTS||oldLines.length?line.type===diffParser.LINE_TYPE.DELETES?oldLines.push(line):line.type===diffParser.LINE_TYPE.INSERTS&&Boolean(oldLines.length)?newLines.push(line):(console.error("unknown state in html side-by-side generator"),processChangeBlock()):(fileHtml.left+=that.generateSingleLineHtml(diffParser.LINE_TYPE.CONTEXT,"","",""),fileHtml.right+=that.generateSingleLineHtml(line.type,line.newNumber,escapedLine,prefix))}processChangeBlock()}),fileHtml},SideBySidePrinter.prototype.processLines=function(oldLines,newLines){var that=this,fileHtml={};fileHtml.left="",fileHtml.right="";for(var maxLinesNumber=Math.max(oldLines.length,newLines.length),i=0;maxLinesNumber>i;i++){var oldContent,newContent,oldPrefix,newPrefix,oldLine=oldLines[i],newLine=newLines[i];oldLine&&(oldContent=utils.escape(oldLine.content.substr(1)),oldPrefix=oldLine.content[0]),newLine&&(newContent=utils.escape(newLine.content.substr(1)),newPrefix=newLine.content[0]),oldLine&&newLine?(fileHtml.left+=that.generateSingleLineHtml(oldLine.type,oldLine.oldNumber,oldContent,oldPrefix),fileHtml.right+=that.generateSingleLineHtml(newLine.type,newLine.newNumber,newContent,newPrefix)):oldLine?(fileHtml.left+=that.generateSingleLineHtml(oldLine.type,oldLine.oldNumber,oldContent,oldPrefix),fileHtml.right+=that.generateSingleLineHtml(diffParser.LINE_TYPE.CONTEXT,"","","")):newLine?(fileHtml.left+=that.generateSingleLineHtml(diffParser.LINE_TYPE.CONTEXT,"","",""),fileHtml.right+=that.generateSingleLineHtml(newLine.type,newLine.newNumber,newContent,newPrefix)):console.error("How did it get here?")}return fileHtml},SideBySidePrinter.prototype.makeSingleLineHtml=function(type,number,htmlContent,htmlPrefix){return'<tr>\n    <td class="d2h-code-side-linenumber '+type+'">'+number+'</td>\n    <td class="'+type+'">      <div class="d2h-code-side-line '+type+'">'+htmlPrefix+htmlContent+"</div>    </td>\n  </tr>\n"},SideBySidePrinter.prototype.generateSingleLineHtml=function(type,number,content,prefix){var htmlPrefix="";prefix&&(htmlPrefix='<span class="d2h-code-line-prefix">'+prefix+"</span>");var htmlContent="";return content&&(htmlContent='<span class="d2h-code-line-ctn">'+content+"</span>"),this.makeSingleLineHtml(type,number,htmlContent,htmlPrefix)},SideBySidePrinter.prototype.generateEmptyDiff=function(){var fileHtml={};return fileHtml.right="",fileHtml.left='<tr>\n  <td class="'+diffParser.LINE_TYPE.INFO+'">    <div class="d2h-code-side-line '+diffParser.LINE_TYPE.INFO+'">File without changes    </div>  </td>\n</tr>\n',fileHtml},module.exports.SideBySidePrinter=SideBySidePrinter}()}]);