"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var renderUtils = __importStar(require("./render-utils"));
var baseTemplatesPath = 'file-summary';
var iconsBaseTemplatesPath = 'icon';
function render(diffFiles, hoganUtils) {
    var files = diffFiles
        .map(function (file) {
        return hoganUtils.render(baseTemplatesPath, 'line', {
            fileHtmlId: renderUtils.getHtmlId(file),
            oldName: file.oldName,
            newName: file.newName,
            fileName: renderUtils.filenameDiff(file),
            deletedLines: '-' + file.deletedLines,
            addedLines: '+' + file.addedLines,
        }, {
            fileIcon: hoganUtils.template(iconsBaseTemplatesPath, renderUtils.getFileIcon(file)),
        });
    })
        .join('\n');
    return hoganUtils.render(baseTemplatesPath, 'wrapper', {
        filesNumber: diffFiles.length,
        files: files,
    });
}
exports.render = render;
//# sourceMappingURL=file-list-renderer.js.map