"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.escapeForRegExp = escapeForRegExp;
exports.unifyPath = unifyPath;
exports.hashCode = hashCode;
exports.max = max;
const specials = [
    '-',
    '[',
    ']',
    '/',
    '{',
    '}',
    '(',
    ')',
    '*',
    '+',
    '?',
    '.',
    '\\',
    '^',
    '$',
    '|',
];
const regex = RegExp('[' + specials.join('\\') + ']', 'g');
function escapeForRegExp(str) {
    return str.replace(regex, '\\$&');
}
function unifyPath(path) {
    return path ? path.replace(/\\/g, '/') : path;
}
function hashCode(text) {
    let i, chr, len;
    let hash = 0;
    for (i = 0, len = text.length; i < len; i++) {
        chr = text.charCodeAt(i);
        hash = (hash << 5) - hash + chr;
        hash |= 0;
    }
    return hash;
}
function max(arr) {
    const length = arr.length;
    let max = -Infinity;
    for (let i = 0; i < length; i++) {
        max = Math.max(max, arr[i]);
    }
    return max;
}
//# sourceMappingURL=utils.js.map