"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimestampRegex = exports.TextRegex = exports.StrikeThroughRegex = exports.SpoilerRegex = exports.EmoticonRegex = exports.CodeBlockRegex = exports.BlockQuoteRegex = exports.HereRegex = exports.EveryoneRegex = exports.UserMentionRegex = exports.RoleMentionRegex = exports.EmojiRegex = exports.ChannelMentionRegex = void 0;
exports.ChannelMentionRegex = /^<#(\d{17,20})>/;
exports.EmojiRegex = /^<(a)?:(\w{2,32}):(\d{17,21})>/;
exports.RoleMentionRegex = /^<@&(\d{17,20})>/;
exports.UserMentionRegex = /^<@!?(\d{17,20})>/;
exports.EveryoneRegex = /^@everyone$/;
exports.HereRegex = /^@here$/;
exports.BlockQuoteRegex = /^( *>>> ([\s\S]*))|^( *> [^\n]*(\n *> [^\n]*)*\n?)/;
exports.CodeBlockRegex = /^```(([a-z0-9-]+?)\n+)?\n*([^]+?)\n*```/i;
exports.EmoticonRegex = /^(¯\\_\(ツ\)_\/¯)/;
exports.SpoilerRegex = /^\|\|([\s\S]+?)\|\|/;
exports.StrikeThroughRegex = /^~~([\s\S]+?)~~(?!_)/;
exports.TextRegex = /^[\s\S]+?(?=[^0-9A-Za-z\s]|\n\n|\n|\w+:\S|$)/;
exports.TimestampRegex = /^<t:(\d+)(?::(R|t|T|d|D|f|F))?>/;
