---
layout: docs
title: Colors
description: You can customise your app’s color scheme to match your brand colors. Alternatively, you can create an entirely new color scheme using the Material Design color palette.
group: material
redirect_from:
  - /docs/4.4/material/colors/
  - /docs/4.5/material/colors/
toc: true
---

Please visit [theming]({{ site.baseurl }}/docs/{{ site.docs_version }}/getting-started/theming/#theme-colors) for detailed information about all Material Design colors and how to customise theme colors.

## Color scheme

In Material Design, a primary color refers to a color that appears most frequently in your app. A secondary color refers to a color used to accent key parts of your UI.

### Primary color

A primary color is the color displayed most frequently across your app’s screens and components. To create contrast between elements, you can use lighter or darker tones of your primary color. The contrast between lighter and darker tones helps show division.

<div class="row">
  <div class="col-md-6 mb-4">
    <div class="bg-primary p-3 text-white-primary">
      <p class="mb-5">
        <strong>Primary</strong>
      </p>
      <div class="d-flex justify-content-between">
        <span class="doc-swatch-text">.bg-primary</span>
        <span class="doc-swatch-text">#6200ee</span>
      </div>
    </div>
    <div class="bg-primary-dark d-flex justify-content-between p-3 text-white-primary">
      <span class="doc-swatch-text">.bg-primary-dark</span>
      <span class="doc-swatch-text">#3700b3</span>
    </div>
    <div class="bg-primary-light d-flex justify-content-between p-3 text-dark-primary">
      <span class="doc-swatch-text">.bg-primary-light</span>
      <span class="doc-swatch-text">#bb86fc</span>
    </div>
  </div>
</div>

### Secondary color

A secondary color is used to accent select parts of your UI. It can be analogous or complementary to your primary color, but it should not simply be a light or dark variation of your primary color. It should contrast with elements that surround it and be applied sparingly as an accent.

Secondary colors are best used for:

- Buttons and floating action buttons
- Headlines
- Links
- Progress bars
- Selection controls and sliders
- Text fields and text selection

<div class="row">
  <div class="col-md-6 mb-4">
    <div class="bg-secondary p-3 text-white-primary">
      <p class="mb-5">
        <strong>Secondary</strong>
      </p>
      <div class="d-flex justify-content-between">
        <span class="doc-swatch-text">.bg-secondary</span>
        <span class="doc-swatch-text">#03dac6</span>
      </div>
    </div>
    <div class="bg-secondary-dark d-flex justify-content-between p-3 text-white-primary">
      <span class="doc-swatch-text">.bg-secondary-dark</span>
      <span class="doc-swatch-text">#018786</span>
    </div>
    <div class="bg-secondary-light d-flex justify-content-between p-3 text-dark-primary">
      <span class="doc-swatch-text">.bg-secondary-light</span>
      <span class="doc-swatch-text">#66fff8</span>
    </div>
  </div>
</div>

## Dark and light theme

Themes let you apply a consistent tone to an app. The theme specifies the darkness of elements. To promote greater consistency between apps, dark and light themes are available to choose from.

<div class="row">
  <div class="col-md-6 mb-4">
    <div class="bg-dark-1 d-flex justify-content-between p-3 text-white-primary">
      <span class="doc-swatch-text">.bg-dark-1</span>
      <span class="doc-swatch-text">#000000</span>
    </div>
    <div class="bg-dark-2 d-flex justify-content-between p-3 text-white-primary">
      <span class="doc-swatch-text">.bg-dark-2</span>
      <span class="doc-swatch-text">#212121</span>
    </div>
    <div class="bg-dark-3 d-flex justify-content-between p-3 text-white-primary">
      <span class="doc-swatch-text">.bg-dark-3</span>
      <span class="doc-swatch-text">#303030</span>
    </div>
    <div class="bg-dark-4 d-flex justify-content-between p-3 text-white-primary">
      <span class="doc-swatch-text">.bg-dark-4</span>
      <span class="doc-swatch-text">#3c3c46</span>
    </div>
  </div>
  <div class="col-md-6 mb-4">
    <div class="bg-light-1 d-flex justify-content-between p-3 text-black-primary">
      <span class="doc-swatch-text">.bg-light-1</span>
      <span class="doc-swatch-text">#e0e0e0</span>
    </div>
    <div class="bg-light-2 d-flex justify-content-between p-3 text-black-primary">
      <span class="doc-swatch-text">.bg-light-2</span>
      <span class="doc-swatch-text">#f5f5f5</span>
    </div>
    <div class="bg-light-3 d-flex justify-content-between p-3 text-black-primary">
      <span class="doc-swatch-text">.bg-light-3</span>
      <span class="doc-swatch-text">#fafafa</span>
    </div>
    <div class="bg-light-4 d-flex justify-content-between p-3 text-black-primary">
      <span class="doc-swatch-text">.bg-light-4</span>
      <span class="doc-swatch-text">#ffffff</span>
    </div>
  </div>
</div>
