function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

import Table from 'table-js';
import { importDecision } from './import/Importer';
import { assign } from 'min-dash';
import { domify, remove as domRemove } from 'min-dom';
import TranslateModule from 'diagram-js/lib/i18n/translate';
import annotationsModule from './features/annotations';
import coreModule from './core';
import decisionTableHeadModule from './features/decision-table-head';
import decisionTablePropertiesModule from './features/decision-table-properties';
import decisionRuleIndicesModule from './features/decision-rule-indices';
import decisoinRulesModule from './features/decision-rules';
import hitPolicyModule from './features/hit-policy';
import viewDrdModule from './features/view-drd';
import PoweredByModule from './features/powered-by';

var Viewer =
/*#__PURE__*/
function (_Table) {
  _inherits(Viewer, _Table);

  function Viewer() {
    var _this;

    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, Viewer);

    var container = Viewer._createContainer();

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Viewer).call(this, assign(options, {
      renderer: {
        container: container
      }
    })));
    _this._container = container;
    return _this;
  }

  _createClass(Viewer, [{
    key: "open",
    value: function open(decision, done) {
      var err; // use try/catch to not swallow synchronous exceptions
      // that may be raised during model parsing

      try {
        if (this._decision) {
          // clear existing rendered diagram
          this.clear();
        } // update decision


        this._decision = decision; // perform import

        return importDecision(this, decision, done);
      } catch (e) {
        err = e;
      } // handle synchronously thrown exception


      return done(err);
    }
    /**
     * Initialize the table, returning { modules: [], config }.
     *
     * @param  {Object} options
     *
     * @return {Object} init config
     */

  }, {
    key: "_init",
    value: function _init(options) {
      var modules = options.modules,
          additionalModules = options.additionalModules,
          config = _objectWithoutProperties(options, ["modules", "additionalModules"]);

      var baseModules = modules || this.getModules();
      var extraModules = additionalModules || [];
      var staticModules = [{
        decisionTable: ['value', this]
      }];
      var allModules = [PoweredByModule].concat(_toConsumableArray(baseModules), _toConsumableArray(extraModules), staticModules);
      return {
        modules: allModules,
        config: config
      };
    }
    /**
     * Register an event listener
     *
     * Remove a previously added listener via {@link #off(event, callback)}.
     *
     * @param {string} event
     * @param {number} [priority]
     * @param {Function} callback
     * @param {Object} [that]
     */

  }, {
    key: "on",
    value: function on(event, priority, callback, target) {
      return this.get('eventBus').on(event, priority, callback, target);
    }
    /**
     * De-register an event listener
     *
     * @param {string} event
     * @param {Function} callback
     */

  }, {
    key: "off",
    value: function off(event, callback) {
      this.get('eventBus').off(event, callback);
    }
    /**
     * Emit an event on the underlying {@link EventBus}
     *
     * @param  {string} type
     * @param  {Object} event
     *
     * @return {Object} event processing result (if any)
     */

  }, {
    key: "_emit",
    value: function _emit(type, event) {
      return this.get('eventBus').fire(type, event);
    }
    /**
     * Attach viewer to given parent node.
     *
     * @param  {Element} parentNode
     */

  }, {
    key: "attachTo",
    value: function attachTo(parentNode) {
      if (!parentNode) {
        throw new Error('parentNode required');
      } // ensure we detach from the
      // previous, old parent


      this.detach();
      var container = this._container;
      parentNode.appendChild(container);

      this._emit('attach', {});
    }
    /**
     * Detach viewer from parent node, if attached.
     */

  }, {
    key: "detach",
    value: function detach() {
      var container = this._container,
          parentNode = container.parentNode;

      if (!parentNode) {
        return;
      }

      this._emit('detach', {});

      domRemove(container);
    }
  }, {
    key: "destroy",
    value: function destroy() {
      _get(_getPrototypeOf(Viewer.prototype), "destroy", this).call(this);

      this.detach();
    }
  }, {
    key: "getModules",
    value: function getModules() {
      return Viewer._getModules();
    }
  }], [{
    key: "_getModules",
    value: function _getModules() {
      return [annotationsModule, coreModule, TranslateModule, decisionTableHeadModule, decisionTablePropertiesModule, decisionRuleIndicesModule, decisoinRulesModule, hitPolicyModule, viewDrdModule];
    }
  }, {
    key: "_createContainer",
    value: function _createContainer() {
      return domify('<div class="dmn-decision-table-container"></div>');
    }
  }]);

  return Viewer;
}(Table);

export { Viewer as default };
//# sourceMappingURL=Viewer.js.map