import AddInput from './components/AddInput';
import AddOutput from './components/AddOutput';
export default function AddInputOutputProvider(components, editorActions, eventBus) {
  components.onGetComponent('cell-inner', function () {
    var context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var cellType = context.cellType,
        index = context.index,
        inputsLength = context.inputsLength,
        outputsLength = context.outputsLength;

    if (cellType === 'input-cell' && index === inputsLength - 1) {
      return AddInput;
    }

    if (cellType === 'output-cell' && index === outputsLength - 1) {
      return AddOutput;
    }
  });
  eventBus.on('addInput', function () {
    editorActions.trigger('addInput');
  });
  eventBus.on('addOutput', function () {
    editorActions.trigger('addOutput');
  });
}
AddInputOutputProvider.$inject = ['components', 'editorActions', 'eventBus'];
//# sourceMappingURL=AddInputOutputProvider.js.map