function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

import AddRuleFootComponent from './components/AddRuleFootComponent';

var AddRule = function AddRule(components, editorActions, eventBus, selection) {
  _classCallCheck(this, AddRule);

  components.onGetComponent('table.foot', function () {
    return AddRuleFootComponent;
  });
  eventBus.on('addRule', function (e, context) {
    var rule = editorActions.trigger('addRule');
    var colIndex = context.colIndex;

    if (rule.cells[colIndex]) {
      selection.select(rule.cells[colIndex]);
    } else {
      selection.select(rule.cells[0]);
    }
  });
};

export { AddRule as default };
AddRule.$inject = ['components', 'editorActions', 'eventBus', 'selection'];
//# sourceMappingURL=AddRule.js.map