import { createVNode, createTextVNode } from "inferno";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { Component } from 'inferno';
import { inject } from 'table-js/lib/components';

var AddRuleFootComponent =
/*#__PURE__*/
function (_Component) {
  _inherits(AddRuleFootComponent, _Component);

  function AddRuleFootComponent(props, context) {
    var _this;

    _classCallCheck(this, AddRuleFootComponent);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(AddRuleFootComponent).call(this, props, context));

    _defineProperty(_assertThisInitialized(_this), "handleClick", function (e) {
      e.stopPropagation();

      _this.addRule(e.target.dataset.colIndex);
    });

    inject(_assertThisInitialized(_this));
    _this.addRule = _this.addRule.bind(_assertThisInitialized(_this));
    return _this;
  }

  _createClass(AddRuleFootComponent, [{
    key: "componentWillMount",
    value: function componentWillMount() {
      this._eventBus = this.context.injector.get('eventBus');
    }
  }, {
    key: "addRule",
    value: function addRule(colIndex) {
      this._eventBus.fire('addRule', {
        colIndex: colIndex
      });
    }
  }, {
    key: "render",
    value: function render() {
      var cols = this.props.cols;
      var cells = [createVNode(1, "td", "add-rule-add", createVNode(1, "span", "dmn-icon-plus action-icon", null, 1, {
        "title": "Add Rule"
      }), 2)];

      var _this$sheet$getRoot = this.sheet.getRoot(),
          businessObject = _this$sheet$getRoot.businessObject;

      if (!businessObject.input || !businessObject.input.length) {
        cells.push(createVNode(1, "td", "input-cell", createTextVNode("-"), 2));
      }

      for (var i = 0; i < cols.length + 1; i++) {
        var className = 'add-rule';

        var _businessObject = cols[i] && cols[i].businessObject;

        var placeholder = '';

        if (_businessObject) {
          if (_businessObject.$instanceOf('dmn:InputClause')) {
            className += ' input-cell';
            placeholder = '-';
          }

          if (_businessObject.$instanceOf('dmn:OutputClause')) {
            className += ' output-cell';
          }
        } else {
          className += ' annotation';
        }

        cells.push(createVNode(1, "td", className, placeholder, 0, {
          "data-col-index": i
        }));
      }

      return createVNode(1, "tfoot", "actionable add-rule", createVNode(1, "tr", null, cells, 0), 2, {
        "onClick": this.handleClick
      });
    }
  }]);

  return AddRuleFootComponent;
}(Component);

export { AddRuleFootComponent as default };
AddRuleFootComponent.$inject = ['sheet'];
//# sourceMappingURL=AddRuleFootComponent.js.map