export function parseString(string) {
  // empty string or no string at all
  if (!string || isEmptyString(string.trim())) {
    return {
      values: []
    };
  } // disjunction


  var values = string.split(',');
  var result = {
    values: []
  };
  var openString = '';
  values.forEach(function (value) {
    openString += value;

    if (/^"[^"]*"$/.test(openString.trim())) {
      result.values.push(openString.trim());
      openString = '';
    } else {
      openString += ',';
    }
  });

  if (!openString) {
    return result;
  }
}

function isEmptyString(string) {
  return string === '';
}

export function getValuesArray(values) {
  return values.map(function (value) {
    return value.value;
  });
}
//# sourceMappingURL=Utils.js.map