import { createVNode, createComponentVNode } from "inferno";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { Component } from 'inferno';
import { is } from 'dmn-js-shared/lib/util/ModelUtil';
import List from 'dmn-js-shared/lib/components/List';
import ValidatedInput from 'dmn-js-shared/lib/components/ValidatedInput';
import { getValuesArray, parseString } from '../Utils';

var AllowedValuesEditing =
/*#__PURE__*/
function (_Component) {
  _inherits(AllowedValuesEditing, _Component);

  function AllowedValuesEditing(props, context) {
    var _this;

    _classCallCheck(this, AllowedValuesEditing);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(AllowedValuesEditing).call(this, props, context));

    _defineProperty(_assertThisInitialized(_this), "onElementsChanged", function () {
      _this.forceUpdate();
    });

    _defineProperty(_assertThisInitialized(_this), "setPredefinedValues", function (values) {
      // inputClause or outputClause
      var target = _this.getAllowedValuesTarget();

      _this.setState({
        values: values
      });

      _this._modeling.editAllowedValues(target, values && getValuesArray(values));
    });

    _defineProperty(_assertThisInitialized(_this), "onListChange", function (values) {
      _this.setPredefinedValues(values);
    });

    _defineProperty(_assertThisInitialized(_this), "onInput", function (_ref) {
      var isValid = _ref.isValid,
          value = _ref.value;

      _this.setState({
        inputValue: value
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onKeyDown", function (_ref2) {
      var isValid = _ref2.isValid,
          event = _ref2.event;

      if (!isEnter(event.keyCode)) {
        return;
      }

      event.stopPropagation();
      event.preventDefault();

      if (isValid) {
        var _this$state = _this.state,
            inputValue = _this$state.inputValue,
            values = _this$state.values;
        var parsedString = parseString(inputValue);

        _this.onListChange((values || []).concat(parsedString.values.map(function (value) {
          return {
            value: value,
            isCheckable: false,
            isRemovable: true,
            group: 'Predefined Values'
          };
        })));

        _this.setState({
          inputValue: ''
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "handleRemovePredifinedValuesClick", function (e) {
      e.stopPropagation();

      _this.removePredefinedValues();
    });

    _defineProperty(_assertThisInitialized(_this), "removePredefinedValues", function () {
      _this.setPredefinedValues(null);
    });

    _this._translate = context.injector.get('translate');
    _this._modeling = context.injector.get('modeling');
    _this._changeSupport = context.changeSupport;

    var _target = _this.getAllowedValuesTarget();

    var _parsedString = parseString(_target.inputValues && _target.inputValues.text || _target.outputValues && _target.outputValues.text || '');

    if (_parsedString) {
      _this.state = {
        values: _parsedString.values.map(function (value) {
          return {
            value: value,
            isCheckable: false,
            isRemovable: true,
            group: 'Predefined Values'
          };
        }),
        inputValue: ''
      };
    } else {
      _this.state = {
        values: null,
        inputValue: ''
      };
    }

    return _this;
  }

  _createClass(AllowedValuesEditing, [{
    key: "componentWillMount",
    value: function componentWillMount() {
      var target = this.getAllowedValuesTarget();

      this._changeSupport.onElementsChanged(target.id, this.onElementsChanged);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var target = this.getAllowedValuesTarget();

      this._changeSupport.offElementsChanged(target.id, this.onElementsChanged);
    }
  }, {
    key: "getAllowedValuesTarget",
    value: function getAllowedValuesTarget() {
      var element = this.getElement();

      if (is(element, 'dmn:LiteralExpression')) {
        return element.$parent;
      } else {
        return element;
      }
    }
  }, {
    key: "getElement",
    value: function getElement() {
      return this.props.context.output || this.props.context.input.inputExpression;
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var element = this.getElement();
      var _this$state2 = this.state,
          inputValue = _this$state2.inputValue,
          values = _this$state2.values;
      return element.typeRef === 'string' ? createVNode(1, "div", "context-menu-container allowed-values-edit", createVNode(1, "div", "dms-form-control", [!isNull(values) && values.length > 0 && createComponentVNode(2, List, {
        "labelComponent": Label,
        "items": values,
        "onChange": this.onListChange
      }), !isNull(values) && !values.length && createVNode(1, "div", null, [createVNode(1, "label", "dms-label", this._translate('Predefined Values'), 0), createVNode(1, "span", "placeholder", this._translate('No values'), 0)], 4), !isNull(values) && createVNode(1, "p", "dms-hint", createVNode(1, "button", "del-values", this._translate('Clear predefined values.'), 0, {
        "type": "button",
        "onClick": this.handleRemovePredifinedValuesClick
      }), 2), createVNode(1, "label", "dms-label", this._translate('Add Predefined Values'), 0), createComponentVNode(2, ValidatedInput, {
        "onInput": this.onInput,
        "onKeyDown": this.onKeyDown,
        "placeholder": '"value", "value", ...',
        "type": "text",
        "validate": function validate(value) {
          if (!parseString(value)) {
            return _this2._translate('Strings must be in double quotes.');
          }
        },
        "value": inputValue
      })], 0), 2) : null;
    }
  }]);

  return AllowedValuesEditing;
}(Component);

export { AllowedValuesEditing as default };

function Label(label) {
  return createVNode(1, "label", "dms-label", label, 0);
} // helpers //////////////////////


function isEnter(keyCode) {
  return keyCode === 13;
}

function isNull(value) {
  return value === null;
}
//# sourceMappingURL=AllowedValuesEditing.js.map