function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

import { closest, matches, query } from 'min-dom';
import cssEscape from 'css.escape';
import { setRange, getRange } from 'selection-ranges';
export var SELECTABLE_SELECTOR = '[contenteditable]';
export var ELEMENT_SELECTOR = '[data-element-id]';
export function getElementId(node) {
  return node.getAttribute('data-element-id');
}
export function getElementCoords(node) {
  var coordsAttr = node.getAttribute('data-coords');

  if (!coordsAttr) {
    return null;
  }

  var _coordsAttr$split = coordsAttr.split(':'),
      _coordsAttr$split2 = _slicedToArray(_coordsAttr$split, 2),
      row = _coordsAttr$split2[0],
      col = _coordsAttr$split2[1];

  return {
    row: row,
    col: col
  };
}
export function getNodeByCoords(elementCoords, container) {
  var coordsAttr = "".concat(elementCoords.row, ":").concat(elementCoords.col);
  return query("[data-coords=\"".concat(cssEscape(coordsAttr), "\"]"), container);
}
export function getNodeById(elementId, container) {
  return query("[data-element-id=\"".concat(cssEscape(elementId), "\"]"), container);
}
export function isUnselectableNode(node) {
  return closest(node, '.no-deselect', true);
}
/**
 * Find semantically _selectable_ element in the nodes ancestors.
 *
 * @param {Element} node
 *
 * @return {Element} node
 */

export function findSelectableAncestor(node) {
  return closest(node, ELEMENT_SELECTOR, true);
}
/**
 * Return focusable node in selectable el.
 *
 * @param  {Element} el
 *
 * @return {Element}
 */

export function getFocusableNode(el) {
  var selector = SELECTABLE_SELECTOR;
  return matches(el, selector) ? el : query(selector, el);
}
/**
 * Ensure element or element childNode has the proper focus.
 *
 * @param {Element} el
 */

export function ensureFocus(el) {
  var focusEl = getFocusableNode(el);

  if (!focusEl) {
    return;
  } // QUIRK: otherwise range and focus related actions may
  // yield errors in older browsers (PhantomJS / IE)


  if (!document.body.contains(focusEl)) {
    return;
  } // nothing to do, if element already has focus


  if (document.activeElement === focusEl) {
    return;
  } // (1) focus


  focusEl.focus(); // (2) set cursor to element end

  var range = getRange(focusEl);

  if (!range || range.end === 0) {
    setRange(focusEl, {
      start: 5000,
      end: 5000
    });
  }
}
//# sourceMappingURL=CellSelectionUtil.js.map